#include <iostream>
#include <cstdint>
#include <cstring>
using namespace std;

static const int P = 999983;
static const uint64_t ONE = 1ULL;
static const int W = (P + 63) >> 6;  

alignas(64) static uint64_t A[W + 1];
alignas(64) static uint64_t F[W + 1];

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const uint64_t Acoef = 618023;
    const uint64_t C = 1;

    int n, s;
    cin >> n >> s;
    
    memset(A, 0, sizeof(A));
    memset(F, 0, sizeof(F));
    
    int inserted = 0;

    for (int step = 0; step < n; ++step) {
        s = int(((uint64_t)s * Acoef + C) % P);

        int word_idx = s >> 6;
        int bit_idx = s & 63;
        uint64_t mask = ONE << bit_idx;
        
        bool parity_even = !(F[word_idx] & mask);
        bool not_in_set = !(A[word_idx] & mask);

        if (parity_even && not_in_set) {
            A[word_idx] |= mask;
            ++inserted;

            size_t len = P - s;
            size_t src = 0;
            size_t dst = s;
            
            while (len >= 256) {
                for (int block = 0; block < 4; ++block) {
                    size_t sw = src >> 6;
                    unsigned soff = src & 63;
                    
                    uint64_t chunk = A[sw] >> soff;
                    if (soff && sw + 1 <= W) {
                        chunk |= (A[sw + 1] << (64 - soff));
                    }
                    
                    size_t dw = dst >> 6;
                    unsigned doff = dst & 63;
                    
                    if (doff == 0) {
                        F[dw] ^= chunk;
                    } else {
                        F[dw] ^= (chunk << doff);
                        if (dw + 1 <= W) {
                            F[dw + 1] ^= (chunk >> (64 - doff));
                        }
                    }
                    
                    src += 64;
                    dst += 64;
                }
                len -= 256;
            }
            
            while (len > 0) {
                size_t sw = src >> 6;
                unsigned soff = src & 63;
                
                uint64_t chunk = A[sw] >> soff;
                if (soff && sw + 1 <= W) {
                    chunk |= (A[sw + 1] << (64 - soff));
                }

                unsigned take = (len >= 64) ? 64 : (unsigned)len;
                if (take < 64) {
                    chunk &= ((ONE << take) - 1ULL);
                }

                size_t dw = dst >> 6;
                unsigned doff = dst & 63;
                
                if (doff == 0) {
                    F[dw] ^= chunk;
                } else {
                    F[dw] ^= (chunk << doff);
                    if (dw + 1 <= W) {
                        F[dw + 1] ^= (chunk >> (64 - doff));
                    }
                }

                src += take;
                dst += take;
                len -= take;
            }
        }
    }

    cout << inserted << '\n';
    return 0;
}
