#include <bits/stdc++.h>
using namespace std;

struct Cell {
    int q, r, val;
};

void T(int &q, int &r) {
    q = -q - r;
}
void R(int &q, int &r) {
    int nq = -r;
    int nr = q + r;
    q = nq;
    r = nr;
}
void L(int &q, int &r) {
    int nq = q + r;
    int nr = -q;
    q = nq;
    r = nr;
}

pair<int,int> preob(int q, int r, int a, int b, int c, int d) {
    return {a*q + b*r, c*q + d*r};
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    int h = 2 * n - 1;

    vector<vector<int>> a(h);
    for (int i = 0; i < h; i++) {
        int len = n + min(i, h - 1 - i);
        a[i].resize(len);
        for (int j = 0; j < len; j++)
            cin >> a[i][j];
    }

    string ops;
    cin >> ops;

    int A = 1, B = 0, C = 0, D = 1;

    for (char c : ops) {
        int a,b,c1,d;
        if (c == 'R') {
            a = 0;
            b = -1;
            c1 = 1;
            d = 1;
        } else if (c == 'L') {
            a = 1;
            b = 1;
            c1 = -1;
            d = 0;
        } else {
            a = -1;
            b = -1;
            c1 = 0;
            d = 1;
        }

        int Anew = a*A + b*C;
        int Bnew = a*B + b*D;
        int Cnew = c1*A + d*C;
        int Dnew = c1*B + d*D;
        A = Anew; B = Bnew; C = Cnew; D = Dnew;
    }

    vector<Cell> cells;
    for (int i = 0; i < h; i++) {
        int len = a[i].size();
        int r = i - (n - 1);
        int q0 = -min(i, n - 1);
        for (int j = 0; j < len; j++) {
            int q = q0 + j;
            auto [q2,r2] = preob(q,r,A,B,C,D);
            cells.push_back({q2,r2,a[i][j]});
        }
    }

    map<pair<int,int>, int> mp;
    for (auto &c : cells) mp[{c.q, c.r}] = c.val;

    for (int i = 0; i < h; ++i) {
        int r = i - (n - 1);
        int len = n + min(i, h - 1 - i);
        int q0 = -min(i, n - 1);

        for(int k = 0; k < abs(n -i - 1); k++){
            cout << " ";
        }

        for (int j = 0; j < len; j++) {
            int q = q0 + j;
            cout << mp[{q,r}];
            if (j+1 < len) cout << ' ';
        }
        cout << '\n';
    }

    return 0;
}
