#include <bits/stdc++.h>

using namespace std;

int get_q_offset(int r, int max_dist) {
    return max(-max_dist, -max_dist - r);
}

int get_length(int r, int max_dist) {
    int q_min = get_q_offset(r, max_dist);
    int q_max = min(max_dist, max_dist - r);
    return (q_max >= q_min) ? q_max - q_min + 1 : 0;
}

pair<int, int> pos_to_coord(int row, int col, int n) {
    int max_dist = n - 1;
    int r = row - max_dist;
    int q_min = get_q_offset(r, max_dist);
    int q = q_min + col;
    return {q, r};
}

pair<int, int> coord_to_pos(int q, int r, int n) {
    int max_dist = n - 1;
    int row = r + max_dist;
    int q_min = get_q_offset(r, max_dist);
    int col = q - q_min;
    return {row, col};
}

pair<int, int> rotate_cw(int q, int r) {
    return {-r, q + r};
}

struct Symmetry {
    bool flipped;
    int k;
    Symmetry(bool f, int kk) : flipped(f), k((kk % 6 + 6) % 6) {}
};

Symmetry mul(const Symmetry& a, const Symmetry& b) {
    int new_k;
    bool new_flipped;
    if (!a.flipped) {
        if (!b.flipped) {
            new_flipped = false;
            new_k = a.k + b.k;
        } else {
            new_flipped = true;
            new_k = (b.k - a.k + 6) % 6;
        }
    } else {
        if (!b.flipped) {
            new_flipped = true;
            new_k = a.k + b.k;
        } else {
            new_flipped = false;
            new_k = (b.k - a.k + 6) % 6;
        }
    }
    return Symmetry(new_flipped, new_k);
}

vector<vector<int>> rotate_grid_cw(const vector<vector<int>>& grid, int n) {
    int max_dist = n - 1;
    vector<vector<int>> new_grid(2 * n - 1);
    for (int row = 0; row < 2 * n - 1; ++row) {
        int r = row - max_dist;
        int len = get_length(r, max_dist);
        new_grid[row].resize(len);
    }
    for (int row = 0; row < 2 * n - 1; ++row) {
        for (int col = 0; col < (int)grid[row].size(); ++col) {
            auto [q, r] = pos_to_coord(row, col, n);
            auto [q_new, r_new] = rotate_cw(q, r);
            auto [new_row, new_col] = coord_to_pos(q_new, r_new, n);
            new_grid[new_row][new_col] = grid[row][col];
        }
    }
    return new_grid;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    cin >> n;
    int max_dist = n - 1;
    vector<vector<int>> grid(2 * n - 1);
    for (int row = 0; row < 2 * n - 1; ++row) {
        int r = row - max_dist;
        int len = get_length(r, max_dist);
        grid[row].resize(len);
        for (int j = 0; j < len; ++j) {
            cin >> grid[row][j];
        }
    }
    string ops;
    cin >> ops;
    Symmetry current(false, 0);
    for (char charr : ops) {
        Symmetry op(false, 0);
        if (charr == 'R') {
            op = Symmetry(false, 1);
        } else if (charr == 'L') {
            op = Symmetry(false, 5);
        } else if (charr == 'T') {
            op = Symmetry(true, 0);
        }
        current = mul(op, current);
    }
    vector<vector<int>> temp_grid = grid;
    for (int i = 0; i < current.k; ++i) {
        temp_grid = rotate_grid_cw(temp_grid, n);
    }
    if (current.flipped) {
        for (auto& row_vec : temp_grid) {
            reverse(row_vec.begin(), row_vec.end());
        }
    }
    for (const auto& row_vec : temp_grid) {
        for (size_t j = 0; j < row_vec.size(); ++j) {
            if (j > 0) cout << " ";
            cout << row_vec[j];
        }
        cout << "\n";
    }
    return 0;
}