#include <bits/stdc++.h>
#define int long long
using namespace std;

const int N = 3e6 + 1000;
const int prime = 1e9 + 7;

vector<int> fact;
vector<int> fact_inv;
vector<int> deg_2;

int poww(int x, int n) {
    if (n == 0)
        return 1;
    if (n % 2 == 0) {
        int y = poww(x, n / 2);
        return (y * y) % prime;
    }

    return (x * poww(x, n - 1)) % prime;
}


int get_inv(int x) {
    return poww(x, prime - 2);
}


void setting() {
    fact.assign(N, 1);
    for (int i = 1; i < N; ++i) {
        fact[i] = (fact[i - 1] * i) % prime;
    }
    fact_inv.assign(N, 1);
    for (int i = 1; i < N; ++i) {
        fact_inv[i] = get_inv(fact[i]);
    }

    deg_2.assign(N, 1);

    for (int i = 1; i < N; ++i) {
        deg_2[i] = (deg_2[i - 1] * 2) % prime;
    }
}


int mul(int a, int b) {
    return (a * b) % prime;
}

int mul(int a, int b, int c) {
    return mul(a, mul(b, c));
}

int mul(int a, int b, int c, int d) {
    return mul(mul(a, b), mul(c, d));
}

int mul(int a, int b, int c, int d, int e) {
    return mul(mul(a, b), mul(c, d), e);
}

int mul(int a, int b, int c, int d, int e, int f) {
    return mul(mul(a, b), mul(c, d), mul(e, f));
}


int get_c_n_k(int n, int k) {
    return mul(fact[n], fact_inv[k], fact_inv[n - k]);
}


void source() {
    int p, m; cin >> p >> m;
    int N = 2 * p + m + 1;

    int s = N;

    for (int i = 1; i <= p; ++i) {
        s = mul(s, 2, i, get_inv(2 * i + 1));
    }

    cout << s << "\n";

}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    int t; cin >> t;
    while (t--)
        source();
}
