#include <iostream>
#include <string>
#include <vector>

using namespace std;

typedef long long ll;
typedef long double ld;
struct point {ll x; ll y;};

int main() {
    int n; cin>>n;
    vector<point> unicorns(n);
    for(auto& [x, y] : unicorns) {
        cin>>x>>y;
    }

    ll max_d_squared{0}; int best_i{-1}, best_j{-1};
    auto d_squared=[](ll a, ll b) {
        return a*a+b*b;
    };

    for(int i=0; i<n; i++) {
        for(int j=0; j<n; j++) {
            auto current_d_squared=d_squared(
                    unicorns[i].x-unicorns[j].x,
                    unicorns[i].y-unicorns[j].y
            );
            if(max_d_squared>=current_d_squared)
                continue;
            max_d_squared=current_d_squared;
            best_i=i;
            best_j=j;
        }
    }

    auto output=[&](int i, int j) {
        auto [r, s]=unicorns[i];
        auto [t, u]=unicorns[j];

        cout<<t-r<<" "<<u-s<<" "<<
        -r*(t-r)-s*(u-s)<<endl;
    };

    output(best_i, best_j);
    output(best_j, best_i);

    return 0;
}
