def modinv(a, mod):
    """Compute modular inverse of a modulo mod using Fermat's little theorem"""
    return pow(a, mod - 2, mod)

def solve():
    MOD = 10**9 + 7
    
    t = int(input())
    for _ in range(t):
        p, m = map(int, input().split())
        
        if p == 0:
            print(0)
            continue
        
        # Use space-optimized DP with memoization for only needed states
        # Instead of full 2D table, use dictionary for sparse states
        memo = {}
        
        def expected_draws(pairs_started, singles_drawn):
            if (pairs_started, singles_drawn) in memo:
                return memo[(pairs_started, singles_drawn)]
            
            remaining_socks = 2 * p + m - pairs_started - singles_drawn
            
            if remaining_socks <= 0:
                memo[(pairs_started, singles_drawn)] = 0
                return 0
            
            # Base case: if we have pairs_started > 0 and only those socks remain
            if pairs_started > 0 and pairs_started == remaining_socks:
                memo[(pairs_started, singles_drawn)] = 1
                return 1
            
            # We draw one sock for sure
            result = 1
            
            # Case 1: Draw a new single sock
            if singles_drawn < m:
                prob_single = (m - singles_drawn) * modinv(remaining_socks, MOD) % MOD
                result = (result + prob_single * expected_draws(pairs_started, singles_drawn + 1)) % MOD
            
            # Case 2: Start a new pair
            if pairs_started < p:
                prob_new_pair = (2 * (p - pairs_started)) * modinv(remaining_socks, MOD) % MOD
                result = (result + prob_new_pair * expected_draws(pairs_started + 1, singles_drawn)) % MOD
            
            memo[(pairs_started, singles_drawn)] = result
            return result
        
        result = expected_draws(0, 0)
        print(result)

solve()