#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <bits/stdc++.h>

using namespace std;
using ll = long long;
const int MOD = 1e9 + 7;
const int MAXN = 2000000;
static ll fact[MAXN+1], inv_fact[MAXN+1], inv_num[MAXN+1];

ll mod_pow(ll a, ll e){
    ll r = 1;
    while(e){
        if(e & 1) r = r * a % MOD;
        a = a * a % MOD;
        e >>= 1;
    }
    return r;
}

void init_all(){
    fact[0] = 1;
    for(int i=1;i<=MAXN;i++) fact[i] = fact[i-1] * i % MOD;
    inv_fact[MAXN] = mod_pow(fact[MAXN], MOD-2);
    for(int i=MAXN;i>0;i--) inv_fact[i-1] = inv_fact[i] * i % MOD;
    inv_num[1] = 1;
    for(int i=2;i<=MAXN;i++) inv_num[i] = (MOD - (MOD / i)) * inv_num[MOD % i] % MOD;
}

struct PairHash {
    size_t operator()(const pair<int,int>&p) const noexcept {
        return ((uint64_t)p.first<<32) ^ (uint32_t)p.second;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    init_all();

    int t;
    if(!(cin>>t)) return 0;
    vector<pair<int,int>> tests(t);
    int maxNseen = 0;
    for(int i=0;i<t;i++){
        int p,m; cin>>p>>m;
        tests[i] = {p,m};
        int n = 2*p + m;
        if(n > maxNseen) maxNseen = n;
    }
    unordered_map<pair<int,int>, int, PairHash> cache;
    cache.reserve(t*2);
    vector<int> answers;
    answers.reserve(t);

    for(auto &tm : tests){
        int p = tm.first, m = tm.second;
        auto key = tm;
        if(auto it = cache.find(key); it != cache.end()){
            answers.push_back(it->second);
            continue;
        }

        int n = 2*p + m;
        int K = p + m;

        ll a_prev = 1;
        ll a_cur = ( (2LL*p + m) % MOD + MOD ) % MOD;

        ll Fk = fact[0] * fact[n] % MOD; 

        ll P = (Fk * a_prev) % MOD;
        if(K >= 1){

            if(n>=1) Fk = Fk * 1 % MOD * inv_num[n] % MOD;
            P = (P + Fk * a_cur) % MOD;
        }

        for(int i=1;i< K; ++i){
            ll t1 = ( (2LL*p + m - 3LL*i) % MOD + MOD ) % MOD;
            ll t2 = ( (2LL*p + 2LL*m - 2LL*i + 2) % MOD + MOD ) % MOD;
            ll a_next = ( t1 * a_cur + t2 * a_prev ) % MOD;
            a_next = a_next * inv_num[i+1] % MOD;

            int kplus = i+1;
            int denom_idx = n - i;
            if(denom_idx >= 1) Fk = Fk * (kplus) % MOD * inv_num[denom_idx] % MOD;
            P += Fk * a_next % MOD;
            if(P >= MOD) P -= MOD;

            a_prev = a_cur;
            a_cur = a_next;
        }

        ll E = P * inv_fact[n] % MOD;
        int out = int(E);
        answers.push_back(out);
        cache.emplace(key, out);
    }

    for(int x : answers) cout << x << '\n';
    return 0;
}
