def get_gex(n):
    gex = []
    for _ in range(n * 2 - 1):
        gex.append(list(map(int, input().split())))
    return gex

def rotate_to_l(gex, n):
    l = []
    # Заполняем новые линии по очереди
    for i in range(len(gex)):
        # Добавили новую линию
        l.append([])
        # Считаем сколько нужно элементов
        line_need = len(gex[i])
        # Добавляем нужное кол-во элементов
        col = max(0, (n - 1) - i)  # вычисляем начальную колонку
        max_col = (n) * 2 - 2 - i  # вычисляем максимальное значение колонки
        for j in range(line_need):
            # Вычисляем строчку
            row = max(0, i - (n - 1)) + j
            # Добавляем элемент
            l[i].append(gex[row][col])
            # Увеличиваем колонку (если нужно)
            if col < max_col:
                col += 1
    return l

def print_gex(gex, n):
    for i in range(n * 2 - 1):
        print(" " * abs(n - i - 1), *gex[i], sep=" ")


n = int(input())
gex = get_gex(n)

commands = input().split('T')
count_reverse = len(commands) - 1
for i in range(len(commands)):
    degree = 0
    for cmd in commands[i]:
        match cmd:
            case 'L':
                degree -= 60
            case 'R':
                degree += 60
    degree %= -360 if degree < 0 else 360
    if degree > 0:
        degree -= 360

    for i in range(degree // -60):
        gex = rotate_to_l(gex, n)
    
    if count_reverse:
        gex = [line[::-1] for line in gex]
        count_reverse -= 1

print_gex(gex, n)
