#include <bits/stdc++.h>
using namespace std;

vector<vector<int>> get_gex(int n) {
    vector<vector<int>> gex;
    for (int i = 0; i < n * 2 - 1; i++) {
        string line;
        getline(cin, line);
        if (line.empty()) { i--; continue; }
        stringstream ss(line);
        vector<int> row;
        int val;
        while (ss >> val)
            row.push_back(val);
        gex.push_back(row);
    }
    return gex;
}

vector<vector<int>> rotate_to_l(const vector<vector<int>>& gex, int n) {
    vector<vector<int>> l;
    int size = gex.size();
    for (int i = 0; i < size; i++) {
        vector<int> line;
        int line_need = gex[i].size();
        int col = max(0, (n - 1) - i);
        int max_col = (n * 2 - 2) - i;
        for (int j = 0; j < line_need; j++) {
            int row = max(0, i - (n - 1)) + j;
            line.push_back(gex[row][col]);
            if (col < max_col) col++;
        }
        l.push_back(line);
    }
    return l;
}

void print_gex(const vector<vector<int>>& gex, int n) {
    for (int i = 0; i < n * 2 - 1; i++) {
        int spaces = abs(n - i - 1);
        for (int s = 0; s < spaces; s++) cout << " ";
        for (int j = 0; j < gex[i].size(); j++) {
            if (j > 0) cout << " ";
            cout << gex[i][j];
        }
        cout << "\n";
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    cin.ignore();

    auto gex = get_gex(n);

    string commands_line;
    getline(cin, commands_line);

    vector<string> commands;
    string part;
    stringstream ss(commands_line);
    while (getline(ss, part, 'T'))
        commands.push_back(part);

    int count_reverse = (int)commands.size() - 1;

    for (auto& cmdset : commands) {
        int degree = 0;
        for (char cmd : cmdset) {
            if (cmd == 'L') degree -= 60;
            else if (cmd == 'R') degree += 60;
        }

        if (degree < 0) degree %= -360;
        else degree %= 360;

        if (degree > 0) degree -= 360;

        int times = degree / -60;
        for (int i = 0; i < times; i++) {
            gex = rotate_to_l(gex, n);
        }

        if (count_reverse > 0) {
            for (auto& line : gex)
                reverse(line.begin(), line.end());
            count_reverse--;
        }
    }

    print_gex(gex, n);
    return 0;
}
