private fun readln() = readLine()!!
private fun readlnLong() = readln().toLong()

private fun readlnStrings() = readln().split(' ')
private fun readlnInts() = readlnStrings().map { it.toInt() }
private fun readlnLongs() = readlnStrings().map { it.toLong() }

private fun isWhiteSpace(c: Char) = c in " \r\n\t"
private fun readString() = generateSequence { System.`in`.read().toChar() }
    .dropWhile { isWhiteSpace(it) }.takeWhile { !isWhiteSpace(it) }.joinToString("")

private fun readInt() = readString().toInt()
private fun readLong() = readString().toLong()
private fun readDouble() = readString().toDouble()

fun printw(any: Any?) {
    print(" $any")
}

const val MOD = 1_000_000_007L

const val ENABLE_PRECALC = false
const val NUMBER = 100_000
val FACTORIALS = if (ENABLE_PRECALC) {
    LongArray(NUMBER)
} else {
    LongArray(0)
}

class DSU(size: Int) {

    // Если el[i] < 0 -> i - представитель своей группы размером abs(el[i])
    // Если el[i] >= 0 -> el[i] ссылка на родителя
    val elements = IntArray(size) { -1 }

    fun find(i: Int): Int {
        val el = elements[i]

        return if (el >= 0) {
            elements[i] = find(el)

            elements[i]
        } else {
            i
        }
    }

    fun size(i: Int): Int {
        val el = find(i)

        return -elements[el]
    }

    fun union(a: Int, b: Int): Boolean {
        val aNode = find(a)
        val bNode = find(b)

        if (aNode == bNode) return false

        val aSize = size(aNode)
        val bSize = size(bNode)

        if (aSize > bSize) {
            elements[bNode] = aNode
            elements[aNode] = -(aSize + bSize)
        } else {
            elements[aNode] = bNode
            elements[bNode] = -(aSize + bSize)
        }

        return true
    }

    fun components(): Int = elements.count { it < 0 }

    fun getRoots(): List<Int> = elements.indices.filter { elements[it] < 0 }
}

class SegmentTree(private val arr: List<Long>, private val operator: (Long, Long) -> Long) {
    private val n = arr.size
    private val tree = LongArray(4 * n)

    init {
        build(0, 0, n - 1)
    }

    private fun build(node: Int, left: Int, right: Int) {
        if (left == right) {
            tree[node] = arr[left]
            return
        }

        val mid = (left + right) / 2
        build(2 * node + 1, left, mid)
        build(2 * node + 2, mid + 1, right)

        tree[node] = operator(tree[2 * node + 1], tree[2 * node + 2]) % MOD
    }

    fun update(index: Int, value: Long) {
        update(0, 0, n - 1, index, value)
    }

    private fun update(node: Int, left: Int, right: Int, index: Int, value: Long) {
        if (left == right) {
            tree[node] = value
            return
        }

        val mid = (left + right) / 2
        if (index <= mid) {
            update(2 * node + 1, left, mid, index, value)
        } else {
            update(2 * node + 2, mid + 1, right, index, value)
        }
        tree[node] = operator(tree[2 * node + 1], tree[2 * node + 2]) % MOD
    }

    fun query(left: Int, right: Int): Long {
        return query(0, 0, n - 1, left, right)
    }

    private fun query(node: Int, left: Int, right: Int, l: Int, r: Int): Long {
        if (r < left || l > right) return 0
        if (l <= left && right <= r) return tree[node]

        val mid = (left + right) / 2
        val leftValue = query(2 * node + 1, left, mid, l, r)
        val rightValue = query(2 * node + 2, mid + 1, right, l, r)
        return operator(leftValue, rightValue) % MOD
    }
}

fun precalc() {
    FACTORIALS[0] = 1
    for (i in (1..<NUMBER)) {
        FACTORIALS[i] = FACTORIALS[i - 1] * i % MOD
    }
}

fun inv(a: Long): Long {
    return pow(a, MOD - 2)
}

fun div(a: Long, b: Long): Long {
    return (a * inv(b)) % MOD
}

fun comb(n: Int, k: Int): Long {
    if (k !in 0..n) return 0L
    if (k == 0 || k == n) return 1L

    val numerator = FACTORIALS[n]
    val denominator = (FACTORIALS[k] * FACTORIALS[n - k]) % MOD
    return div(numerator, denominator)
}

fun pow(base: Long, exponent: Long): Long {
    if (exponent == 0L) return 1L

    val half = pow(base, exponent / 2)
    var result = (half * half) % MOD

    if (exponent % 2 == 1L) {
        result = (result * base) % MOD
    }

    return result
}

fun main() {
    if (ENABLE_PRECALC) {
        precalc()
    }

    var n = 1
//    n = readInt()
    repeat(n) {
        solve()
    }
}


fun solve() {
    val n = readInt()

    val matrix = List(2 * n - 1) { index ->
        val cnt = if (index < n) {
            n + index
        } else {
            3 * n - index - 2
        }

        List(cnt) {readInt()}
    }

//    System.err.println(matrix)

    val commands = readString()
    val optimizedCommands = optimizeCommands(commands)

//    System.err.println(optimizedCommands)

    var elements = matrix
    for (command in optimizedCommands) {
        elements = when(command) {
            'L' -> rotateLeft(elements)
            'R' -> rotateRight(elements)
            'T' -> transpose(elements)
            else -> throw IllegalArgumentException("Unknown command")
        }
    }

//    System.err.println(elements)

    for (row in elements) {
        for (element in row) {
            printw(element)
        }
        println()
    }
}

fun optimizeCommands(commands: String): String {
    val startElements = listOf(0, 1, 2, 3, 4, 5, 6)
    var elements = listOf(0, 1, 2, 3, 4, 5, 6)

    for (command in commands) {
        elements = simpleRotate(elements, command)
    }

    var startState = mapOf<List<Int>, String>(
        startElements to ""
    )

    while (startState[elements] == null) {
        val newStartState = mutableMapOf<List<Int>, String>()

        for ((stateElements, stateCommand) in startState) {
            for (command in "LRT") {
                newStartState[simpleRotate(stateElements, command)] = stateCommand + command
            }
        }

        startState = newStartState
    }

    return startState[elements]!!
}

fun simpleRotate(elements: List<Int>, command: Char): List<Int> {
    val newElements = mutableListOf<Int>(0, 0, 0, 0, 0, 0, 0)

    when (command) {
        'L' -> {
            newElements[0] = elements[1]
            newElements[1] = elements[4]
            newElements[2] = elements[0]
            newElements[3] = elements[3]
            newElements[4] = elements[6]
            newElements[5] = elements[2]
            newElements[6] = elements[5]
        }
        'R' -> {
            newElements[0] = elements[2]
            newElements[1] = elements[0]
            newElements[2] = elements[5]
            newElements[3] = elements[3]
            newElements[4] = elements[1]
            newElements[5] = elements[6]
            newElements[6] = elements[4]
        }
        'T' -> {
            newElements[0] = elements[1]
            newElements[1] = elements[0]
            newElements[2] = elements[4]
            newElements[3] = elements[3]
            newElements[4] = elements[2]
            newElements[5] = elements[6]
            newElements[6] = elements[5]
        }
        else -> throw Exception("52")
    }

    return newElements
}

data class HexCoodinates(val x: Int, val y: Int, val z: Int) {
    init {
        require(x + y + z == 0) { "Invalid cube coords: x+y+z must equal 0" }
    }
}

fun toHex(r: Int, c: Int, n: Int): HexCoodinates {
    val z = r - n/2
    val x = c - (n/2 + minOf(0, z))
    val y = -x - z
    return HexCoodinates(x, y, z)
}

fun fromHex(hex: HexCoodinates, n: Int): Pair<Int, Int> {
    val r = hex.z + n/2
    val c = hex.x + (n/2 + minOf(0, hex.z))
    return r to c
}

fun rotateRight(matrix: List<List<Int>>): List<List<Int>> {
    val n = matrix.size
    val result = List(n) { MutableList(matrix[it].size) { 0 } }

    for (r in matrix.indices) {
        for (c in matrix[r].indices) {
            val hex = toHex(r, c, n)
            val rHex = HexCoodinates(-hex.z, -hex.x, -hex.y)
            val (r2, c2) = fromHex(rHex, n)
            if (r2 in result.indices && c2 in result[r2].indices) {
                result[r2][c2] = matrix[r][c]
            }
        }
    }
    return result
}

fun rotateLeft(matrix: List<List<Int>>): List<List<Int>> {
    val n = matrix.size
    val result = List(n) { MutableList(matrix[it].size) { 0 } }

    for (r in matrix.indices) {
        for (c in matrix[r].indices) {
            val hex = toHex(r, c, n)
            val rHex = HexCoodinates(-hex.y, -hex.z, -hex.x)
            val (r2, c2) = fromHex(rHex, n)
            if (r2 in result.indices && c2 in result[r2].indices) {
                result[r2][c2] = matrix[r][c]
            }
        }
    }
    return result
}


fun transpose(matrix: List<List<Int>>): List<List<Int>> {
    val n = matrix.size
    val result = List(n) { MutableList(matrix[it].size) { 0 } }

    for (r in matrix.indices) {
        val sz = matrix[r].size
        for (c in matrix[r].indices) {
            result[r][sz - c - 1] = matrix[r][c]
        }
    }

    return result
}