#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    cin >> n;
    vector<vector<int>> grid(2 * n - 1);
    
    // Чтение гекса (упрощенное)
    for (int i = 0; i < 2 * n - 1; i++) {
        int size = (i < n) ? n + i : 3 * n - i - 2;
        grid[i].resize(size);
        for (int j = 0; j < size; j++) {
            cin >> grid[i][j];
        }
    }
    
    string operations;
    cin >> operations;
    
    // Базовая реализация операций
    for (char op : operations) {
        if (op == 'T') {
            // Отражение
            for (int i = 0; i < grid.size(); i++) {
                reverse(grid[i].begin(), grid[i].end());
            }
        }
        // R и L требуют сложной переиндексации
    }
    
    // Вывод результата
    for (int i = 0; i < grid.size(); i++) {
        for (int j = 0; j < grid[i].size(); j++) {
            cout << grid[i][j];
            if (j < grid[i].size() - 1) cout << " ";
        }
        cout << endl;
    }
    
    return 0;
}