#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1000000007;

long long modPow(long long a, long long b, long long mod) {
    long long res = 1;
    while (b > 0) {
        if (b & 1) res = res * a % mod;
        a = a * a % mod;
        b >>= 1;
    }
    return res;
}

long long modInverse(long long a, long long mod) {
    return modPow(a, mod - 2, mod);
}

int main() {
    int t;
    cin >> t;
    
    while (t--) {
        int p, m;
        cin >> p >> m;
        
        long long total = 2LL * p + m;
        long long numerator = (3LL * total + 1) % MOD;
        long long denominator = 3LL % MOD;
        
        long long result = numerator * modInverse(denominator, MOD) % MOD;
        cout << result << endl;
    }
    
    return 0;
}