#include <iostream>
#include <atomic>
#include <vector>
#include <algorithm>
#include <functional>
#include <cassert>
#include <stack>
#include <string>
#include <iterator>
#include <chrono>
#include <iomanip>
#include <random>
using namespace std;

using namespace std;
typedef long long ll;
typedef pair<ll, ll> pll;
typedef vector<ll> vll;
typedef long double ld;
typedef unsigned long long ull;
typedef string str;
#define forn(i, start, end) for (ll i = start; i < end; ++i)
#define revforn(i, start, end) for (ll i = start; i > end; --i)
#define trav(x, a) for (auto &x : a)
#define ZERO(box) memset(box, 0, sizeof(box))
#define ZERO_N(box, n) memset(box, 0, n * sizeof(*box))
#define SET_ARR(box, val) memset(box, val, sizeof(box))
#define iallvec(vec) copy(istream_iterator<ll>(cin), istream_iterator<ll>(), back_inserter(vec))
#define iarr(arr, size) copy_n(istream_iterator<ll>(cin), size, begin(arr))
#define icharr(arr, size) copy_n(istream_iterator<char>(cin), size, begin(arr))
#define ovec(vec, delimiter) copy(begin(vec), end(vec), ostream_iterator<ll>(cout, delimiter))
#define oarr(arr, size, delimiter) copy_n(begin(arr), size, ostream_iterator<ll>(cout, delimiter))
#define ocharr(arr, size, delimiter) copy_n(begin(arr), size, ostream_iterator<char>(cout, delimiter))
#define ifout(term) cout << (term ? "YES" : "NO")
#define beginend(a) begin(a), end(a)
#define TIMER_START auto TIME_START = chrono::high_resolution_clock::now()
#define TIMER_FINISH chrono::duration<double> TIME_DURATION = chrono::high_resolution_clock::now() - TIME_START; cout << TIME_DURATION.count() << " seconds" << endl

template <class T>
bool ckmin(T &a, const T &b)
{
  return b < a ? a = b, 1 : 0;
}
template <class T>
bool ckmax(T &a, const T &b) { return a < b ? a = b, 1 : 0; }

std::random_device dev;
std::mt19937 rng(dev());
ll get_rand(const ll &l, const ll &r)
{
  assert(r >= l);
  std::uniform_int_distribution<std::mt19937::result_type> dist(l, r);
  return dist(rng);
}

// https://codeforces.com/blog/entry/62393
struct custom_hash
{
  static uint64_t splitmix64(uint64_t x)
  {
    // http://xorshift.di.unimi.it/splitmix64.c
    x += 0x9e3779b97f4a7c15;
    x = (x ^ (x >> 30)) * 0xbf58476d1ce4e5b9;
    x = (x ^ (x >> 27)) * 0x94d049bb133111eb;
    return x ^ (x >> 31);
  }

  size_t operator()(uint64_t x) const
  {
    static const uint64_t FIXED_RANDOM = chrono::steady_clock::now().time_since_epoch().count();
    return splitmix64(x + FIXED_RANDOM);
  }
};

const ll mod = 1e9 + 7;
const ld eps = 1e-10;
const ld pi = acosl(-1.0);
const ll N = 1e6 + 4;
const ll inf = 1e18;


auto solveA() {
  int h, m;
  cin >> h >> m;
  int cnt = 0;
  for (int i = 0; i < h;i++) {
    for (int j = 0; j < m;j++) {
      int a = i / 10;
      int b = i % 10;
      int c = j / 10;
      int d = j % 10;
      if (a == 2 && j == 39) {
        if (b == 0 || b == 2 || b == 3)
          cnt++;
      }
      else if (b == 2 && j == 39) {
        cnt++;
      }
      else if (i == 23 && d == 9 ){
        if (c == 0 || c == 3 || c == 9)
          cnt++;
      }
      else if (i == 23 && c == 9)
        cnt++;
    }
  }
  cout << cnt;
}

auto solveB() {

}

using ld = long double;

auto solveC() {
  ld n, p;
  cin >> n >> p;

  ld all_sum = 10.0 * (n);

  for (int i = 1; i <= 10; i++) {
    all_sum -= n * (1 + i * p / 1000.0);
  }

  std::cout << std::fixed << setprecision(10)<< -all_sum << "\n";
}
auto solveD() {
  int n;
  cin >> n;
  vector<int> a(n);
  ll sm = 0;
  for (int i = 0; i < n;i++) {
    cin >> a[i];
    sm += a[i];
  }
  ll mn = 1e18, mx = 0;
  for (int mask = 0; mask < (1 << n);mask++) {
    ll sm1 = 0;
    for (int i = 0; i < n;i++) {
      if ((mask >> i) & 1)
        sm1 += a[i];
    }
    ll cur = sm1 * (sm - sm1);
    if (cur > 0)
      mn = min(mn, cur);
    mx = max(mx, cur);
  }
  cout << mn << ' ' << mx;
}

auto solveE() {
  int n;
  cin >> n;
  int d = (int)(9 * n) / 10;
  for (int x = 0; x <= n;x++) {
    cout << abs(x - d) << ' ' << n - abs(n - x - d) << "\n";
  }
}

auto solveF() {
  ld x1, y1,x2,y2,x3,y3,x4,y4;
  cin >> x1 >> y1 >>x2>>y2>>x3>>y3>>x4>>y4;

  ld d1 = sqrtl((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
  ld d2 = sqrtl((x2-x3)*(x2-x3)+(y2-y3)*(y2-y3));

  std::cout << std::fixed<<std::setprecision(10) << d1*d2*pi/4 << "\n";
}
vector<vector<pll>> lr_bounds_by_letter(7);
bool init_lr = false;
auto solveG() {
  if (!init_lr) {
    forn(letter, 0, 7) {
      ll i = letter;
      while (i < 52) {
        lr_bounds_by_letter[letter].push_back({i, 52-i-1});
        i+=7;
      }
    }
    init_lr = true;
  }
  str s;
  cin>>s;
  ll first_letter = s[0]-'A';
  ll mn = 0, mx = 0;
  char cur_letter = s[0];
  ll cur_sm = 0;
  forn(i,1,s.size()) {
    ll acc = s[i] - cur_letter;
    if (acc < 0)
      acc+=7;
    if (acc <= 3)
      cur_sm+=acc;
    else
      cur_sm-=7-acc;
    ckmin(mn, cur_sm);
    ckmax(mx, cur_sm);
    cur_letter=s[i];
  }
  bool ans = false;
  trav(p, lr_bounds_by_letter[first_letter]) {
    if (p.first >= -mn && p.second >= mx) {
      ans = true;
      break;
    }
  }
  ifout(ans);
  cout<<'\n';
}

void f(ll x1, ll y1, ll x2, ll y2) {

  ll A = y2 - y1;
  ll B = x1 - x2;
  ll C = x2 * y1 - x1 * y2;
  cout << A << ' ' << B << ' ' << C << "\n";
}

auto solveJ() {
  int n;
  cin >> n;
  vector<ll> x(n), y(n);
  forn(i, 0, n) {
    cin >> x[i] >> y[i];
  }
  ll mx = 0;
  int im = 0, jm = 0;
  forn(i, 0, n) {
    forn(j, 0, n) {
      if ((x[i] - x[j]) * (x[i] - x[j]) + (y[i] - y[j]) * (y[i] - y[j]) > mx) {
        mx = (x[i] - x[j]) * (x[i] - x[j]) + (y[i] - y[j]) * (y[i] - y[j]);
        im = i;
        jm = j;
      }
    }
  }

  ll vy = x[im] - x[jm];
  ll vx = -y[im] + y[jm];

  f(x[im], y[im], x[im] + vx, y[im] + vy);
  f(x[jm], y[jm], x[jm] + vx, y[jm] + vy);
}


using i64 = long long;
using u64 = unsigned long long;
using u32 = unsigned;

using u128 = unsigned __int128;
using i128 = __int128;


template<class T>
constexpr T power(T a, u64 b, T res = 1) {
    for (; b != 0; b /= 2, a *= a) {
        if (b & 1) {
            res *= a;
        }
    }
    return res;
}

template<u32 P>
constexpr u32 mulMod(u32 a, u32 b) {
    return u64(a) * b % P;
}

template<u64 P>
constexpr u64 mulMod(u64 a, u64 b) {
    u64 res = a * b - u64(1.L * a * b / P - 0.5L) * P;
    res %= P;
    return res;
}

constexpr i64 safeMod(i64 x, i64 m) {
    x %= m;
    if (x < 0) {
        x += m;
    }
    return x;
}

constexpr std::pair<i64, i64> invGcd(i64 a, i64 b) {
    a = safeMod(a, b);
    if (a == 0) {
        return {b, 0};
    }

    i64 s = b, t = a;
    i64 m0 = 0, m1 = 1;

    while (t) {
        i64 u = s / t;
        s -= t * u;
        m0 -= m1 * u;

        std::swap(s, t);
        std::swap(m0, m1);
    }

    if (m0 < 0) {
        m0 += b / s;
    }

    return {s, m0};
}

template<std::unsigned_integral U, U P>
struct ModIntBase {
public:
    constexpr ModIntBase() : x(0) {}
    template<std::unsigned_integral T>
    constexpr ModIntBase(T x_) : x(x_ % mod()) {}
    template<std::signed_integral T>
    constexpr ModIntBase(T x_) {
        using S = std::make_signed_t<U>;
        S v = x_ % S(mod());
        if (v < 0) {
            v += mod();
        }
        x = v;
    }

    constexpr static U mod() {
        return P;
    }

    constexpr U val() const {
        return x;
    }

    constexpr ModIntBase operator-() const {
        auto v = invGcd(x, mod());
        assert(v.first == 1);
        return v.second;
    }

    constexpr ModIntBase inv() const {
        return power(*this, mod() - 2);
    }

    constexpr ModIntBase &operator*=(const ModIntBase &rhs) & {
        x = mulMod<mod()>(x, rhs.val());
        return *this;
    }
    constexpr ModIntBase &operator+=(const ModIntBase &rhs) & {
        x += rhs.val();
        if (x >= mod()) {
            x -= mod();
        }
        return *this;
    }
    constexpr ModIntBase &operator-=(const ModIntBase &rhs) & {
        x -= rhs.val();
        if (x >= mod()) {
            x += mod();
        }
        return *this;
    }
    constexpr ModIntBase &operator/=(const ModIntBase &rhs) & {
        return *this *= rhs.inv();
    }

    friend constexpr ModIntBase operator*(ModIntBase lhs, const ModIntBase &rhs) {
        lhs *= rhs;
        return lhs;
    }
    friend constexpr ModIntBase operator+(ModIntBase lhs, const ModIntBase &rhs) {
        lhs += rhs;
        return lhs;
    }
    friend constexpr ModIntBase operator-(ModIntBase lhs, const ModIntBase &rhs) {
        lhs -= rhs;
        return lhs;
    }
    friend constexpr ModIntBase operator/(ModIntBase lhs, const ModIntBase &rhs) {
        lhs /= rhs;
        return lhs;
    }

    friend constexpr std::istream &operator>>(std::istream &is, ModIntBase &a) {
        i64 i;
        is >> i;
        a = i;
        return is;
    }
    friend constexpr std::ostream &operator<<(std::ostream &os, const ModIntBase &a) {
        return os << a.val();
    }

    friend constexpr bool operator==(const ModIntBase &lhs, const ModIntBase &rhs) {
        return lhs.val() == rhs.val();
    }
    friend constexpr std::strong_ordering operator<=>(const ModIntBase &lhs, const ModIntBase &rhs) {
        return lhs.val() <=> rhs.val();
    }

private:
    U x;
};

template<u32 P>
using ModInt = ModIntBase<u32, P>;
template<u64 P>
using ModInt64 = ModIntBase<u64, P>;

struct Barrett {
public:
    Barrett(u32 m_) : m(m_), im((u64)(-1) / m_ + 1) {}

    constexpr u32 mod() const {
        return m;
    }

    constexpr u32 mul(u32 a, u32 b) const {
        u64 z = a;
        z *= b;

        u64 x = u64((u128(z) * im) >> 64);

        u32 v = u32(z - x * m);
        if (m <= v) {
            v += m;
        }
        return v;
    }

private:
    u32 m;
    u64 im;
};

template<u32 Id>
struct DynModInt {
public:
    constexpr DynModInt() : x(0) {}
    template<std::unsigned_integral T>
    constexpr DynModInt(T x_) : x(x_ % mod()) {}
    template<std::signed_integral T>
    constexpr DynModInt(T x_) {
        int v = x_ % int(mod());
        if (v < 0) {
            v += mod();
        }
        x = v;
    }

    constexpr static void setMod(u32 m) {
        bt = m;
    }

    static u32 mod() {
        return bt.mod();
    }

    constexpr u32 val() const {
        return x;
    }

    constexpr DynModInt operator-() const {
        DynModInt res;
        res.x = (x == 0 ? 0 : mod() - x);
        return res;
    }

    constexpr DynModInt inv() const {
        auto v = invGcd(x, mod());
        assert(v.first == 1);
        return v.second;
    }

    constexpr DynModInt &operator*=(const DynModInt &rhs) & {
        x = bt.mul(x, rhs.val());
        return *this;
    }
    constexpr DynModInt &operator+=(const DynModInt &rhs) & {
        x += rhs.val();
        if (x >= mod()) {
            x -= mod();
        }
        return *this;
    }
    constexpr DynModInt &operator-=(const DynModInt &rhs) & {
        x -= rhs.val();
        if (x >= mod()) {
            x += mod();
        }
        return *this;
    }
    constexpr DynModInt &operator/=(const DynModInt &rhs) & {
        return *this *= rhs.inv();
    }

    friend constexpr DynModInt operator*(DynModInt lhs, const DynModInt &rhs) {
        lhs *= rhs;
        return lhs;
    }
    friend constexpr DynModInt operator+(DynModInt lhs, const DynModInt &rhs) {
        lhs += rhs;
        return lhs;
    }
    friend constexpr DynModInt operator-(DynModInt lhs, const DynModInt &rhs) {
        lhs -= rhs;
        return lhs;
    }
    friend constexpr DynModInt operator/(DynModInt lhs, const DynModInt &rhs) {
        lhs /= rhs;
        return lhs;
    }

    friend constexpr std::istream &operator>>(std::istream &is, DynModInt &a) {
        i64 i;
        is >> i;
        a = i;
        return is;
    }
    friend constexpr std::ostream &operator<<(std::ostream &os, const DynModInt &a) {
        return os << a.val();
    }

    friend constexpr bool operator==(const DynModInt &lhs, const DynModInt &rhs) {
        return lhs.val() == rhs.val();
    }
    friend constexpr std::strong_ordering operator<=>(const DynModInt &lhs, const DynModInt &rhs) {
        return lhs.val() <=> rhs.val();
    }

private:
    u32 x;
    static Barrett bt;
};

template<u32 Id>
Barrett DynModInt<Id>::bt = 998244353;

using Z = ModInt<1000000007>;

struct Comb {
    int n;
    std::vector<Z> _fac;
    std::vector<Z> _invfac;
    std::vector<Z> _inv;

    Comb() : n{0}, _fac{1}, _invfac{1}, _inv{0} {}
    Comb(int n) : Comb() {
        init(n);
    }

    void init(int m) {
        if (m <= n) return;
        _fac.resize(m + 1);
        _invfac.resize(m + 1);
        _inv.resize(m + 1);

        for (int i = n + 1; i <= m; i++) {
            _fac[i] = _fac[i - 1] * i;
        }
        _invfac[m] = _fac[m].inv();
        for (int i = m; i > n; i--) {
            _invfac[i - 1] = _invfac[i] * i;
            _inv[i] = _invfac[i] * _fac[i - 1];
        }
        n = m;
    }

    Z fac(int m) {
        if (m > n) init(2 * m);
        return _fac[m];
    }
    Z invfac(int m) {
        if (m > n) init(2 * m);
        return _invfac[m];
    }
    Z inv(int m) {
        if (m > n) init(2 * m);
        return _inv[m];
    }
    Z binom(int n, int m) {
        if (n < m || m < 0) return 0;
        return fac(n) * invfac(m) * invfac(n - m);
    }
} comb;

auto solveH() {
  int n;
  cin >> n;
  vector<int> a(n + 1);
  for (int i = 1; i <= n; i++) {
    cin >> a[i];
  }

  vector<int> p(n + 1);
  vector<bool> used(n + 1, 0);
  for (int i = 1; i <= n; i++) {
    int cnt = a[i];

    int found = 0;
    for (int z = n; z >= 1; z--) {
      if (!used[z]) {
        found++;
        if (found == cnt + 1) {
          used[z] = true;
          p[z] = i;
          break;
        }
      }
    }
  }
  for (int i = 1; i <= n; i++) {
    cout << p[i] << " ";
  }
  cout << "\n";
}

auto solveL() {
    const ll max_predpod = 1e7;
    vector<bool> div4(max_predpod+1, false);
    vector<bool> div8(max_predpod+1, false);
    for(ll x = 3; x <= max_predpod; x+=2) {
        ll colatz = x*3ll+1ll;
        if (colatz%8 == 0) {
            div8[x] = div4[x] = true;
        }
        else if (colatz%4 == 0)
            div4[x] = true;
    }
    ll cur;
    cin>>cur;
    const ll iter_threshold = 30;
    while (cur!=1) {
        ll cur2 = cur;
        bool good = false;
        forn(i,0,iter_threshold) {
            if (cur2 & 1) {
                cur2 = 3ll*cur2 + 1ll;
                if (cur2 > 1e18)
                    break;
            }
            else
                cur2 >>= 1;
            if (cur2 == 1) {
                good =true;break;
                }
        }
        if (good) {
            cout << "collatz" << '\n' << flush;
        }
    else {
        if (cur & 1) {
            if (cur > max_predpod || div8[cur]) {
                cout << "collatz" << '\n' << flush;
            }
            else if (div4[cur]) {
                if (get_rand(0,1))
                    cout << "collatz" << '\n' << flush;
                else
                    cout << "random" << '\n' << flush;
            }
            else {
                cout << "random" << '\n' << flush;
            }
        }
        else {
            cout << "collatz" << '\n' << flush;
        }
    }
        cin >> cur;
    }
}

void first() {

    int n;
    cin >> n;
    vector<ll> a(n);
    for (auto &el: a) cin >> el;

    ll sum = std::accumulate(a.begin(), a.end(), 0LL);
    ll res = (sum) % n;
    if (res == 0) res = n;
    std::cout << res << "\n";
}
void second(ll num) {
    i64 s;
    cin >> s;

    i64 sum = 0;
    for (int i = 1; i <= s; i++) {
        ll e;
        cin >> e;
        sum += e;
    }

    ll result = (num + (s + 1) - sum % (s + 1)) % (s + 1);
    if (result == 0) {
        result = s + 1;
    }
    cout << result << "\n";
}

void solveI() {
    int num;
    cin >> num;
    if (num == 0) {
        first();
    } else {
        second(num);
    }
}

int main()
{
#ifdef RSMTDEBUG
  ifstream cin("input.txt");
  // freopen("input.txt", "r", stdin);
  // freopen("output.txt", "w", stdout);
#endif
  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);
  int t = 1;
    cin>>t;
  while (t--) {
    solveL();
  }

  return 0;
}