#include <algorithm>
#include <chrono>
#include <complex>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>
#include <set>
#include <cmath>
#include <map>
#include <vector>

#define ELAPSED_TIME (std::chrono::duration_cast<chrono::milliseconds>(std::chrono::steady_clock::now() - start_time).count())


using ll = long long;

constexpr ll INF = 1e17;

// constexpr ll ROOT_FACTOR = 1;

using namespace std;

void print(int n, const vector<vector<int>> &v) {
    for (int i = 0; i < 2 * n - 1; ++i) {
        for (int j = 0; j < n - min(i, 2 * n - 2 - i); ++j) {
            cout << " ";
        }
        for (int j: v[i]) {
            cout << j << " ";
        }
        cout << "\n";
    }
}

ll fpow(ll a, ll b, ll m) {
    ll res = 1 % m;
    for (; b > 0; b >>= 1) {
        if (b & 1)
            res = (res * a) % m;
        a = (a * a) % m;
    }
    return res;
}


int coll(ll x, int niter) {
    int iter = 0;
    for (int i = 0; i < niter; ++i) {
        if (x == 1) return iter;
        if (x % 2 == 0) {
            x /= 2;
        } else {
            if (x > static_cast<ll>(1e18)) return niter;
            x = 3 * x + 1;
        }
        ++iter;
    }
    return iter;
}

map<ll, bool> cash;

int main() {
    int t;
    cin >> t;
    for (int _ = 0; _ < t; ++_) {
        ll x;
        while (true) {
            cin >> x;
            if (x == 0) return 0;
            if (x == 1) break;
            int maxiter = 3 * static_cast<int>(log(x)) + 1;
            if (x % 2 == 1) {
                bool flag;
                if (cash.contains(x)) {
                    flag = cash[x];
                } else {
                    flag = coll(x, maxiter + 1) >= maxiter;
                    cash[x] = flag;
                }
                if (flag) {
                    cout << "random" << endl;
                } else {
                    cout << "collatz" << endl;
                }
            } else {
                cout << "collatz" << endl;
            }
        }
    }
}


/*




3
4 1 8
3 5 1 7
2 1 6 1 8
1 7 1 9
8 9 9
TL

TR




 */
