﻿#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX = 3e6 + 5;

int fact[MAX], invfact[MAX], pow2[MAX];

int modpow(int a, int e) {
    int res = 1;
    while (e) {
        if (e & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        e >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAX; i++) {
        fact[i] = 1LL * fact[i - 1] * i % MOD;
    }
    invfact[MAX - 1] = modpow(fact[MAX - 1], MOD - 2);
    for (int i = MAX - 2; i >= 0; i--) {
        invfact[i] = 1LL * invfact[i + 1] * (i + 1) % MOD;
    }
    pow2[0] = 1;
    for (int i = 1; i < MAX; i++) {
        pow2[i] = 2LL * pow2[i - 1] % MOD;
    }
}

int nCr(int n, int r) {
    if (r < 0 || r > n) return 0;
    return 1LL * fact[n] * invfact[r] % MOD * invfact[n - r] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    precompute();

    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        int n = 2 * p + m;

        vector<int> Cm(m + 1), Cp(p + 1);
        for (int i = 0; i <= m; i++) Cm[i] = nCr(m, i);
        for (int i = 0; i <= p; i++) Cp[i] = nCr(p, i);

        long long ans = 0;

        for (int k = 0; k <= p + m; k++) {
            long long sum = 0;
            int start = max(0, k - m);
            int end = min(p, k);

            if (start > end) {
                break;
            }

            for (int i = start; i <= end; i++) {
                sum = (sum + 1LL * Cp[i] * pow2[i] % MOD * Cm[k - i]) % MOD;
            }

            long long prob = sum * modpow(nCr(n, k), MOD - 2) % MOD;
            ans = (ans + prob) % MOD;
        }

        cout << ans << "\n";
    }

    return 0;
}