﻿#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1000000007;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    if (!(cin >> T)) return 0;

    vector<int> P(T), S(T);
    int maxP = 0;

    for (int i = 0; i < T; ++i) {
        cin >> P[i] >> S[i];
        if (P[i] > maxP) maxP = P[i];
    }

    int up = 2 * maxP + 1;
    vector<int> inv(up + 1);
    inv[1] = 1;
    for (int i = 2; i <= up; ++i) {
        inv[i] = MOD - (long long)(MOD / i) * inv[MOD % i] % MOD;
    }

    for (int i = 0; i < T; ++i) {
        int p = P[i], t = S[i];
        long long tw = 2LL * p;

        int term = 1, sum = 1;
        for (int k = 0; k < p; ++k) {
            term = (long long)term * 2 % MOD;
            term = (long long)term * (p - k) % MOD;
            term = (long long)term * inv[tw - k] % MOD;

            sum += term;
            if (sum >= MOD) sum -= MOD;
        }

        long long denominator = tw + 1;
        long long numerator = (tw + t + 1) % MOD;
        int ans = (long long)sum * numerator % MOD * inv[denominator] % MOD;

        cout << ans << '\n';
    }

    return 0;
}