﻿#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1000000007;

long long mod_pow(long long base, long long exp, long long mod) {
    long long result = 1;
    while (exp > 0) {
        if (exp & 1) result = result * base % mod;
        base = base * base % mod;
        exp >>= 1;
    }
    return result;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    vector<int> P(T), S(T);
    int maxP = 0;

    for (int i = 0; i < T; ++i) {
        cin >> P[i] >> S[i];
        if (P[i] > maxP) maxP = P[i];
    }

    int n = 2 * maxP + 2;
    vector<long long> fact(n + 1), inv_fact(n + 1);

    fact[0] = 1;
    for (int i = 1; i <= n; ++i) {
        fact[i] = fact[i - 1] * i % MOD;
    }

    inv_fact[n] = mod_pow(fact[n], MOD - 2, MOD);
    for (int i = n - 1; i >= 0; --i) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }

    auto comb = [&](int n, int k) -> long long {
        if (k < 0 || k > n) return 0;
        return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
        };

    for (int i = 0; i < T; ++i) {
        int p = P[i], t = S[i];

        long long sum = 0;
        long long term = 1;

        for (int k = 0; k <= p; ++k) {
            sum = (sum + term) % MOD;
            if (k < p) {
                term = term * 2 % MOD;
                term = term * (p - k) % MOD;
                term = term * mod_pow(2LL * p - k, MOD - 2, MOD) % MOD;
            }
        }

        long long numerator = (2LL * p + t + 1) % MOD;
        long long denominator_inv = mod_pow(2LL * p + 1, MOD - 2, MOD);

        long long ans = sum * numerator % MOD * denominator_inv % MOD;
        cout << ans << '\n';
    }

    return 0;
}