﻿#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1000000007;

long long mod_pow(long long base, long long exp, long long mod) {
    long long result = 1;
    while (exp > 0) {
        if (exp & 1) result = result * base % mod;
        base = base * base % mod;
        exp >>= 1;
    }
    return result;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    vector<int> P(T), S(T);
    int maxP = 0;

    for (int i = 0; i < T; ++i) {
        cin >> P[i] >> S[i];
        if (P[i] > maxP) maxP = P[i];
    }

    int up = 2 * maxP + 5;
    vector<int> inv(up + 1);
    inv[1] = 1;
    for (int i = 2; i <= up; ++i) {
        inv[i] = MOD - (long long)(MOD / i) * inv[MOD % i] % MOD;
    }

    for (int i = 0; i < T; ++i) {
        int p = P[i], t = S[i];
        long long tw = 2LL * p;

        int term = 1, sum = 1;
        for (int k = 0; k < p; ++k) {
            term = (long long)term * 2 % MOD;
            term = (long long)term * (p - k) % MOD;
            term = (long long)term * inv[tw - k] % MOD;
            sum = (sum + term) % MOD;
        }

        long long numerator = (tw + t + 1) % MOD;
        long long ans = (long long)sum * numerator % MOD;
        ans = ans * inv[tw + 1] % MOD;

        cout << ans << '\n';
    }

    return 0;
}