#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0') & 1) == 0; }
static inline int digits(const string& s){ return (int)s.size(); }

static unsigned v2_cap(const string& s, unsigned cap){
    unsigned M = 1u << cap, rem = 0;
    for(char c: s) rem = (rem * 10u + (unsigned)(c - '0')) % M;
    if(rem == 0) return cap;
    unsigned k = 0;
    while(k < cap && ((rem >> k) & 1u) == 0u) ++k;
    return k;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    const long long TARGET = 30000;
    long long spent = 0;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        bool blue_used = false;

        while(true){
            if(is_one(x)) break;

            long long remaining_rounds = t - round;
            long long rounds_done = round;
            double avg_so_far = (rounds_done == 0 ? 0.0 : (double)spent / rounds_done);
            double cushion = 10.0;

            bool need_blue = (avg_so_far > 600.0 - cushion);

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
                continue;
            }

            if(!blue_used && need_blue && digits(x) <= 6){
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
                if(is_one(x)) continue;

                unsigned v = v2_cap(x, 12);
                if(v >= 8){
                    blue_used = true;
                    while(!is_one(x) && is_even(x)){
                        cout << "collatz\n" << flush;
                        if(!(cin >> x)) return 0;
                        if(x == "0") return 0;
                        spent += digits(x);
                    }
                    continue;
                }else{
                    blue_used = true;
                    cout << "collatz\n" << flush;
                    if(!(cin >> x)) return 0;
                    if(x == "0") return 0;
                    spent += digits(x);
                    continue;
                }
            }else{
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
            }
        }
    }
    return 0;
}
