#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <cstdint>
using namespace std;

struct Point
{
    int x, y;
    Point(int x_val, int y_val) : x(x_val), y(y_val) {}
};

int orientation(Point p, Point q, Point r)
{
    int val = (q.y - p.y) * (r.x - q.x) -
              (q.x - p.x) * (r.y - q.y);

    if (val == 0) return 0; 
    return (val > 0)? 1: 2;
}

vector<Point> convexHull(vector<Point> points)
{
    int64_t n = points.size();

    if (n < 3) return points;
    vector<Point> hull;
    int l = 0;
    for (int i = 1; i < n; i++)
        if (points[i].x < points[l].x)
            l = i;
    int p = l, q;
    do
    {
        hull.push_back(points[p]);
        q = (p+1)%n;
        for (int i = 0; i < n; i++)
        {
           if (orientation(points[p], points[i], points[q]) == 2)
               q = i;
        }
        p = q;

    } while (p != l);

    return hull;
}

int64_t cross(Point a, Point b, Point c) {
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

int64_t scalar(Point a, Point b, Point c) {
    return (b.x - a.x)*(c.x - a.x)+(b.y - a.y)* (c.y - a.y);
}
int64_t dist(Point a, Point b){
    return scalar(a, b, b);
}

vector<Point> delete_non_vertex(vector<Point> hull) {
    
    if (hull.size() <= 2) {
        return hull;
    }
    std::vector<Point> result;
    for (size_t i = 0; i < hull.size(); i++) {
        Point prev = hull[(i - 1 + hull.size()) % hull.size()];
        Point curr = hull[i];
        Point next = hull[(i + 1) % hull.size()];
        if (std::abs(cross(prev, curr, next)) > 0) {
            result.push_back(curr);
        } else {
            if (scalar(curr, prev, next) > 0) {
                result.push_back(curr);
            }
        }
    }
    
    return result;
}


std::pair<Point, Point> rotating_calipers(std::vector<Point>& hull) {
    int n = hull.size();
    if (n == 2) {
        int64_t distance = dist(hull[0], hull[1]);
        return {hull[0], hull[1]};
    }
    
    int k = 1;
    int64_t max_distance = 0.0;
    std::pair<Point, Point> max_pair = {hull[0], hull[1]};
    for (int i = 0; i < n; i++) {
        while (cross(hull[i], hull[(i + 1) % n], hull[(k + 1) % n]) > 
               cross(hull[i], hull[(i + 1) % n], hull[k])) {
            k = (k + 1) % n;
        }
        
        int64_t current_dist = dist(hull[i], hull[k]);
        if (current_dist > max_distance) {
            max_distance = current_dist;
            max_pair = {hull[i], hull[k]};
        }
    }
    
    return max_pair;
}

int main()
{
    int64_t n;
    cin>>n;
    vector<Point> a;
    int64_t x, y;
    for (int64_t i=0; i<n; i++) {
        cin>>x>>y;
        a.push_back(Point(x, y));
    }
    vector<Point> hull = delete_non_vertex(convexHull(a));
    pair<Point, Point> ans = rotating_calipers(hull);
    int64_t x1, y1, x2, y2;
    x1 = ans.first.x;
    y1 = ans.first.y;
    x2 = ans.second.x;
    y2 = ans.second.y;
    
    int64_t coef_x = x1 - x2;
    int64_t coef_y = y1 - y2;
    int64_t c_first = -coef_x*x1-coef_y*y1;
    int64_t c_second = -coef_x*x2-coef_y*y2;
    cout << coef_x<<" "<<coef_y<<" "<<c_first<<endl;
    cout << coef_x<<" "<<coef_y<<" "<<c_second<<endl;
    return 0;
}