import java.io.BufferedInputStream
import java.io.PrintWriter

private class FastScanner {
    private val input = BufferedInputStream(System.`in`)
    private val buffer = ByteArray(1 shl 16)
    private var len = 0
    private var ptr = 0

    private fun readByte(): Int {
        if (ptr >= len) {
            len = input.read(buffer)
            ptr = 0
            if (len < 0) return -1
        }
        return buffer[ptr++].toInt()
    }

    fun nextInt(): Int {
        var c = readByte()
        while (c <= 32 && c >= 0) c = readByte()
        var sign = 1
        if (c == '-'.code) {
            sign = -1
            c = readByte()
        }
        var res = 0
        while (c > 32) {
            res = res * 10 + (c - '0'.code)
            c = readByte()
        }
        return if (sign == 1) res else -res
    }
}

fun main() {
    val fs = FastScanner()
    val n = fs.nextInt()

    val A = n * 9 / 10
    val T = n / 10

    val out = PrintWriter(System.out)
    for (x in 0..n) {
        val L = kotlin.math.max(0, x - A)
        val R = kotlin.math.min(T, x)
        val sMin = 2 * L + (A - x)
        val sMax = 2 * R + (A - x)
        out.println("$sMin $sMax")
    }
    out.flush()
}
