#include <iostream>

const uint64_t c1  = 0x5555555555555555;
const uint64_t c2  = 0x3333333333333333;
const uint64_t c4  = 0x0f0f0f0f0f0f0f0f;
const uint64_t c8  = 0x00ff00ff00ff00ff;
const uint64_t c16 = 0x0000ffff0000ffff;
const uint64_t c32 = 0x00000000ffffffff;

int count_ones(uint64_t x)
{
    x = (x & c1 ) + ((x >>  1) & c1 );
    x = (x & c2 ) + ((x >>  2) & c2 );
    x = (x & c4 ) + ((x >>  4) & c4 );
    x = (x & c8 ) + ((x >>  8) & c8 );
    x = (x & c16) + ((x >> 16) & c16);
    x = (x & c32) + ((x >> 32) & c32);
    return x;
}

int main(void)
{
    int c;
    std::cin >> c;
    std::cout << count_ones(c) << std::endl;
}