import java.io.*;
import java.util.*;

public class gex {
    static class FastScanner {
        private final InputStream in;
        private final byte[] buffer = new byte[1 << 16];
        private int ptr = 0, len = 0;
        FastScanner(InputStream is) { in = is; }
        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buffer);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buffer[ptr++];
        }
        int nextInt() throws IOException {
            int c;
            do c = read(); while (c <= 32 && c != -1);
            int sign = 1;
            if (c == '-') {
                sign = -1;
                c = read();
            }
            int x = 0;
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return x * sign;
        }
        String next() throws IOException {
            int c;
            do c = read(); while (c <= 32 && c != -1);
            StringBuilder sb = new StringBuilder();
            while (c > 32) {
                sb.append((char)c);
                c = read();
            }
            return sb.toString();
        }
    }

    static long packKey(int x, int y, int z) {
        int off = 1000;
        long X = x + off;
        long Y = y + off;
        long Z = z + off;
        return (X << 22) ^ (Y << 11) ^ Z;
    }

    static int[][] mul(int[][] a, int[][] b) {
        int[][] c = new int[3][3];
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                int s = 0;
                for (int k = 0; k < 3; k++) {
                    s += a[i][k] * b[k][j];
                }
                c[i][j] = s;
            }
        }
        return c;
    }

    static int[] apply(int[][] m, int x, int y, int z) {
        int nx = m[0][0]*x + m[0][1]*y + m[0][2]*z;
        int ny = m[1][0]*x + m[1][1]*y + m[1][2]*z;
        int nz = m[2][0]*x + m[2][1]*y + m[2][2]*z;
        return new int[]{nx, ny, nz};
    }

    public static void main(String[] args) throws Exception {
        FastScanner fs = new FastScanner(System.in);
        int n = fs.nextInt();
        int rows = 2*n - 1;
        int r0 = n - 1;

        ArrayList<int[]> coordsList = new ArrayList<>();
        ArrayList<Integer> valuesList = new ArrayList<>();
        ArrayList<int[]> rowsCoords = new ArrayList<>();

        for (int row = 0; row < rows; row++) {
            int y = r0 - row;
            int xMin = Math.max(-r0, -r0 - y);
            int xMax = Math.min(r0,  r0 - y);
            int lenRow = xMax - xMin + 1;
            int[] idxsThisRow = new int[lenRow];
            for (int xi = 0; xi < lenRow; xi++) {
                int x = xMin + xi;
                int z = -x - y;
                int val = fs.nextInt();
                int idx = coordsList.size();
                coordsList.add(new int[]{x,y,z});
                valuesList.add(val);
                idxsThisRow[xi] = idx;
            }
            rowsCoords.add(idxsThisRow);
        }

        String ops = fs.next();

        int[][] Lmat = {
                { 0,-1, 0},
                { 0, 0,-1},
                {-1, 0, 0}
        };
        int[][] Tmat = {
                { 0, 0, 1},
                { 0, 1, 0},
                { 1, 0, 0}
        };
        int[][] Rmat = {
                { 0, 0,-1},
                {-1, 0, 0},
                { 0,-1, 0}
        };

        int[][] curMat = {
                {1,0,0},
                {0,1,0},
                {0,0,1}
        };

        for (int i = 0; i < ops.length(); i++) {
            char c = ops.charAt(i);
            if (c == 'L') {
                curMat = mul(Lmat, curMat);
            } else if (c == 'T') {
                curMat = mul(Tmat, curMat);
            } else {
                curMat = mul(Rmat, curMat);
            }
        }

        HashMap<Long,Integer> finalMap = new HashMap<>(coordsList.size()*2);

        for (int idx = 0; idx < coordsList.size(); idx++) {
            int[] xyz = coordsList.get(idx);
            int[] nxyz = apply(curMat, xyz[0], xyz[1], xyz[2]);
            long key = packKey(nxyz[0], nxyz[1], nxyz[2]);
            finalMap.put(key, valuesList.get(idx));
        }

        StringBuilder out = new StringBuilder();
        for (int row = 0; row < rowsCoords.size(); row++) {
            int y = r0 - row;
            int[] idxs = rowsCoords.get(row);
            if (idxs.length > 0) {
                for (int j = 0; j < idxs.length; j++) {
                    int baseIdx = idxs[j];
                    int[] xyz = coordsList.get(baseIdx);
                    int[] orig = xyz;
                    int x = orig[0];
                    int z = orig[2];
                    long key = packKey(x, y, z);
                    int val = finalMap.get(key);
                    if (j > 0) out.append(' ');
                    out.append(val);
                }
            }
            out.append('\n');
        }

        System.out.print(out.toString());
    }
}
