#include <iostream>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <algorithm>
#include <bits/stdc++.h>

using namespace std;

int first(const vector<int>& cards) {
  unordered_map<int, int> counter;
  for (int num : cards) {
      counter[num]++;
  }
  for (size_t i = 0; i < cards.size(); ++i) {
      if (counter[cards[i]] == 1) {
          return (int)(i + 1); 
      }
  }
  return 1; 
}

int second(const vector<int>& cards, int n_players) {
  unordered_set<int> all_;
  for (int i = 1; i <= n_players; ++i) {
      all_.insert(i);
  }
  unordered_set<int> seen(cards.begin(), cards.end());

  vector<int> candidates;
  for (int num = 1; num <= n_players; ++num) {
      if (seen.find(num) == seen.end()) {
          candidates.push_back(num);
      }
  }
  if (candidates.size() == 1) {
      return candidates[0];
  } else {
      return *min_element(candidates.begin(), candidates.end());
  }
}

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);
  int mode, n_players;
  cin >> mode >> n_players;
  vector<int> cards(n_players);
  for (int i = 0; i < n_players; ++i) {
      cin >> cards[i];
  }

  if (mode == 0) {
      int winner = first(cards);
      cout << winner << endl;
  } else {
      int winner_number = second(cards, n_players);
      cout << winner_number << endl;
  }

  return 0;
}