cross = lambda pa, pb, pc: (pb[0] - pa[0]) * (pc[1] - pa[1]) - (pb[1] - pa[1]) * (pc[0] - pa[0])
dist_sq = lambda pa, pb: (pb[0] - pa[0])**2 + (pb[1] - pa[1])**2
 
n = int(input())
points = []
for _ in range(n):
    line = input().split()
    points.append((int(line[0]), int(line[1])))
 
points.sort()
 
lower = []
for p in points:
    while len(lower) >= 2 and cross(lower[-2], lower[-1], p) < 0:
        lower.pop()
    lower.append(p)
 
upper = []
for p in reversed(points):
    while len(upper) >= 2 and cross(upper[-2], upper[-1], p) < 0:
        upper.pop()
    upper.append(p)
 
hull = lower[:-1] + upper[:-1]
m = len(hull)
 
if m < 2:
    p1 = points[0]
    p2 = points[-1]
    a = p2[1] - p1[1]
    b = p1[0] - p2[0]
    c1 = -(a * p1[0] + b * p1[1])
    c2 = c1
    print(a, b, c1)
    print(a, b, c2)
else:
    max_dist_sq = -1
    best_p_i, best_p_j = (0, 0), (0, 0)
    j = 1
 
    for i in range(m):
        p_i = hull[i]
         
        while dist_sq(p_i, hull[(j + 1) % m]) > dist_sq(p_i, hull[j % m]):
            j += 1
         
        p_j = hull[j % m]
        current_dist_sq = dist_sq(p_i, p_j)
 
        if current_dist_sq > max_dist_sq:
            max_dist_sq = current_dist_sq
            best_p_i = p_i
            best_p_j = p_j
         
        p_i_plus_1 = hull[(i + 1) % m]
        current_dist_sq_next_edge = dist_sq(p_i_plus_1, p_j)
        if current_dist_sq_next_edge > max_dist_sq:
            max_dist_sq = current_dist_sq_next_edge
            best_p_i = p_i_plus_1
            best_p_j = p_j
 
    x1, y1 = best_p_i
    x2, y2 = best_p_j
 
    a = x2 - x1
    b = y2 - y1
 
    c1 = -(a * x1 + b * y1)
    c2 = -(a * x2 + b * y2)
     
    print(a, b, c1)
    print(a, b, c2)