import sys
def can_play(melody):
    pos = {
        'A': [0, 7, 14, 21, 28, 35, 42, 49],
        'B': [1, 8, 15, 22, 29, 36, 43, 50],
        'C': [2, 9, 16, 23, 30, 37, 44, 51],
        'D': [3, 10, 17, 24, 31, 38, 45],
        'E': [4, 11, 18, 25, 32, 39, 46],
        'F': [5, 12, 19, 26, 33, 40, 47],
        'G': [6, 13, 20, 27, 34, 41, 48]
    }
    possible = [set(pos[melody[0]])]
    
    for note in melody[1:]:
        next_possible = set()
        for k in pos[note]:
            if any(abs(k - prev) <= 3 for prev in possible[-1]):
                next_possible.add(k)
        if not next_possible:
            return 'NO'
        possible.append(next_possible)
    return 'YES'

t = int(input())
for _ in range(t):
    melody = input().strip()
    print(can_play(melody))

