#include <iostream>
#include <string>
#include <vector>
#include <cstring>

int main() {
    const int pos[7][8] = {
        {0, 7, 14, 21, 28, 35, 42, 49},  
        {1, 8, 15, 22, 29, 36, 43, 50}, 
        {2, 9, 16, 23, 30, 37, 44, 51},  
        {3, 10, 17, 24, 31, 38, 45, -1}, 
        {4, 11, 18, 25, 32, 39, 46, -1},
        {5, 12, 19, 26, 33, 40, 47, -1},
        {6, 13, 20, 27, 34, 41, 48, -1} 
    };

    const int note_count[7] = { 8, 8, 8, 7, 7, 7, 7 };

    int t;
    std::cin >> t;

    while (t--) {
        std::string melody;
        std::cin >> melody;

        bool reachable[52];
        bool next_reachable[52];

        std::memset(reachable, false, sizeof(reachable));
        int first_note = melody[0] - 'A';
        for (int i = 0; i < note_count[first_note]; ++i) {
            reachable[pos[first_note][i]] = true;
        }

        bool possible = true;

        for (size_t i = 1; i < melody.length(); ++i) {
            std::memset(next_reachable, false, sizeof(next_reachable));

            int note_idx = melody[i] - 'A';
            bool found = false;

            for (int j = 0; j < note_count[note_idx]; ++j) {
                int curr_pos = pos[note_idx][j];

                for (int prev_pos = curr_pos - 3; prev_pos <= curr_pos + 3; ++prev_pos) {
                    if (prev_pos >= 0 && prev_pos < 52 && reachable[prev_pos]) {
                        next_reachable[curr_pos] = true;
                        found = true;
                        break;
                    }
                }
            }

            if (!found) {
                possible = false;
                break;
            }
            std::memcpy(reachable, next_reachable, sizeof(reachable));
        }

        std::cout << (possible ? "YES" : "NO") << "\n";
    }

    return 0;
}