#include <bits/stdc++.h>
using namespace std;
using ull = unsigned long long;

// t = v2(3x+1)
static inline int v2_3x1(ull x) {
    ull y = 3*x + 1;
    int t = 0;
    while ((y & 1ull) == 0) { y >>= 1; ++t; }
    return t;
}

static inline pair<ull,int> nextOdd(ull x) {
    ull y = 3*x + 1;
    int t = 0;
    while ((y & 1ull) == 0) { y >>= 1; ++t; }
    return {y, t};
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T; 
    cin >> T;

    const int LOOKAHEAD = 5;
    const ull BIG_X = 1000000;
    const int MAX_RANDOM_STREAK = 3;

    for (int _ = 0; _ < T; ++_) {
        ull x; 
        cin >> x;

        int random_streak = 0;

        while (true) {
            if (x == 1) break;
            if (x == 0) return 0;

            if ((x & 1ull) == 0) {
                cout << "collatz\n" << flush;
                random_streak = 0;
            } else {
                if ((x & 7ull) == 5ull) {
                    cout << "collatz\n" << flush;
                    random_streak = 0;
                } else if ((x & 3ull) == 1ull) {
                    cout << "collatz\n" << flush;
                    random_streak = 0;
                } else {
                    int consec_t1 = 0;
                    ull y = x;
                    for (int d = 0; d < LOOKAHEAD; ++d) {
                        auto [z, t] = nextOdd(y);
                        if (t == 1) ++consec_t1;
                        else break;
                        y = z;
                    }

                    bool bad_run = (consec_t1 >= 2);
                    if (bad_run && x >= BIG_X && random_streak < MAX_RANDOM_STREAK) {
                        cout << "random\n" << flush;
                        ++random_streak;
                    } else {
                        cout << "collatz\n" << flush;
                        random_streak = 0;
                    }
                }
            }

            cin >> x;
        }
    }
    return 0;
}
