import java.util.*;
import java.io.*;

public class ICPC {
    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int t = Integer.parseInt(br.readLine().trim());

        ArrayList<Integer>[] pos = new ArrayList[7];
        for (int i = 0; i < 7; i++) pos[i] = new ArrayList<>();
        for (int i = 0; i < 52; i++) pos[i % 7].add(i);

        StringBuilder sb = new StringBuilder();
        while (t-- > 0) {
            String s = br.readLine().trim();
            int L = s.length();

            boolean[] reach = new boolean[52];
            int first = s.charAt(0) - 'A';
            for (int idx : pos[first]) reach[idx] = true;

            for (int k = 1; k < L; k++) {
                int letter = s.charAt(k) - 'A';
                int[] pref = new int[53];
                for (int i = 0; i < 52; i++) pref[i+1] = pref[i] + (reach[i] ? 1 : 0);

                boolean[] next = new boolean[52];
                for (int j : pos[letter]) {
                    int Lr = Math.max(0, j - 3);
                    int Rr = Math.min(51, j + 3);
                    if (pref[Rr + 1] - pref[Lr] > 0) next[j] = true;
                }
                reach = next;

                boolean any = false;
                for (boolean b : reach) { if (b) { any = true; break; } }
                if (!any) break;
            }

            boolean ok = false;
            for (boolean b : reach) if (b) { ok = true; break; }
            sb.append(ok ? "Yes" : "No").append('\n');
        }
        System.out.print(sb);
    }
}
