import random
from sys import stdout

from functools import lru_cache
import pickle

@lru_cache(maxsize=None)
def collatz_cost(n):
    if n == 1:
        return 1
    elif n % 2 == 0:
        next_n = n // 2
    else:
        next_n = 3 * n + 1
    return len(str(next_n)) + collatz_cost(next_n)

t = int(input())


for i in range(t):
    n = int(input())

    is_done = False

    cost = collatz_cost(n)

    if cost < 707:
        while True:
            print("collatz")
            stdout.flush()
            n = int(input())
            if n == 1:
                break
        continue
    else:
        while True:
            if is_done or n == 1:
                break

            while n % 2 == 0:
                print("collatz")
                stdout.flush()
                n = int(input())
                if n == 1:
                    is_done = True
                    break
            
            cost = collatz_cost(n)
            if cost < 707:
                # while n is not 1 do collatz operation
                print("collatz")
                stdout.flush()
                n = int(input())
                if n == 1:
                    is_done = True
                    break

            else:
                # do random operation
                print("random")
                stdout.flush()
                n = int(input())
                if n == 1:
                    is_done = True
                    break
