//#include <cassert>
//
//const int MAX_MEM = 5e8;
//int mpos = 0;
//char mem[MAX_MEM];
//using namespace std;
//
//void *operator new(size_t n)
//{
//    assert((mpos += n) <= MAX_MEM);
//    return (void *) (mem + mpos - n);
//}
//
//void operator delete(void *) noexcept
//{}
//
//void operator delete(void *, size_t) noexcept
//{}

//#pragma  GCC target("popcnt")

#include <bits/stdc++.h>
#include "ext/pb_ds/assoc_container.hpp"
#include "ext/pb_ds/tree_policy.hpp"
#define int long long
using namespace std;
using namespace __gnu_pbds;
typedef long double ld;
typedef unsigned long long ull;
typedef long long ll;
template<typename T>
using ordered_multiset = tree<T, null_type, less<T>, rb_tree_tag, tree_order_statistics_node_update>;

template<typename T1, typename T2>
ostream &operator<<(ostream &_out, const pair<T1, T2> &_a)
{
    _out << _a.first << ' ' << _a.second << '\n';
    return _out;
}

template<typename T1, typename T2>
istream &operator>>(istream &_in, pair<T1, T2> &_a)
{
    _in >> _a.first >> _a.second;
    return _in;
}

template<typename T>
ostream &operator<<(ostream &_out, const vector<T> &_a)
{
    for (const auto &i: _a)_out << i << ' ';
    return _out;
}

template<typename T>
ostream &operator<<(ostream &_out, const vector<vector<T>> &_a)
{
    for (const auto &i: _a)_out << i << '\n';
    return _out;
}

template<typename T>
istream &operator>>(istream &_in, vector<T> &_a)
{
    for (auto &i: _a)_in >> i;
    return _in;
}

void print(bool x)
{
    if (x)cout << "White\n";
    else cout << "Black\n";
}

template<typename T, typename integer>
void in(vector<T> &a, integer &n)
{
    cin >> n;
    a.resize(n);
    cin >> a;
}

template<typename T, typename integer>
void in_vc(vector<T> &a, const integer &n)
{
    a.resize(n);
    cin >> a;
}

struct A
{
    int a;
    int b;
    int c;

    A(int a = {}, int b = {}, int c = {}) : a(a), b(b), c(c)
    {}

    void rot60()
    {
        swap(a, b);
        swap(c, b);
    }

    void rot120()
    {
        swap(a, b);
        swap(a, c);
    }
};

template<typename T>
struct r
{
    T x, y;

    r() = default;

    r(const T &x, const T &y)
    {
        this->x = x;
        this->y = y;
    }

    r(const pair<T, T> &a) : r(a.first, a.second)
    {}

    template<typename T1>
    explicit r(const r<T1> &other):r(other.x, other.y)
    {}

    r operator+(const r<T> &other) const
    {
        return r(x + other.x, y + other.y);
    }

    [[nodiscard]] ll size() const
    {
        ll ans = (x * x + y * y);
        return ans;
    }

    r<ld> normalize()
    {
        ld sz = this->size();
        return (*this) / sz;
    }

    r<T> normal()
    {
        return {-y, x};
    }

    ld getAngle()
    {
        return atan2(y, x);
    }

    r operator-() const
    {
        return (*this) * (-1);
    }

    r operator-(const r<T> &other) const
    {
        return *this + (-other);
    }

    r operator*(const T &other) const
    {
        return r(other * x, y * other);
    }

    r operator/(const T &other) const
    {
        return ((r<ld>) *this) * (1.0L / other);
    }

    void operator+=(const r<T> &other)
    {
        x += other.x;
        y += other.y;
    }

    void operator-=(const r<T> &other)
    {
        (*this) += -other;
    }

    /*
     if res>0 =>    
     if res=0 =>  
     if res<0 =>  
        ,      z,    ,    >=0!!!
     true_version: res/(z*other.z);
     */
    T operator*(const r<T> &other) const
    {
        return x * other.x + y * other.y;
    }

    bool operator==(const r<T> &other) const
    {
        return (x == other.x) && (y == other.y);
    }

    bool operator!=(const r<T> &other) const
    {
        return !((*this) == other);
    }

    /*
      res=0  ()
      res>0,     ,      , .    ,
        .
      res<0,     .
     */
    T operator%(const r<T> &other) const
    {
        return x * other.y - y * other.x;
    }

    //   
    bool operator<(const r<T> &other) const
    {
        int type = y > 0 || (y == 0 && x >= 0);
        int otherType = other.y > 0 || (other.y == 0 && other.x >= 0);
        if (type != otherType)return type > otherType;
        T ans = (*this) % (other);
        return ans > 0 || (ans == 0 && this->size() < other.size());
    }

    bool operator>(const r<T> &other) const
    {
        return other < (*this);
    }

    bool operator<=(const r<T> &other) const
    {
        return (*this) < other || (*this) == other;
    }

    bool operator>=(const r<T> &other) const
    {
        return other <= (*this);
    }
};


template<typename T>
istream &operator>>(istream &in, r<T> &a)
{
    in >> a.x >> a.y;
    return in;
}

template<typename T>
ostream &operator<<(ostream &out, const r<T> &a)
{
    out << pair<ld, ld>(1.0L * a.x, 1.0L * a.y);
    return out;
}

template<typename T>
ostream &operator<<(ostream &_out, const vector<r<T>> &_a)
{
    for (const auto &i: _a)_out << i;
    return _out;
}

using pt = r<ll>;

vector<pt> convex_hull(vector<pt> a)
{
    pt res = a[0];
    for (auto i: a)
    {
        if (i.y < res.y || (i.y == res.y && i.x < res.x))res = i;
    }
    for (auto &x: a)x -= res;
    std::sort(a.begin(), a.end());
    a.resize(unique(a.begin(), a.end()) - a.begin());
    vector<pt> ans;
    ans.emplace_back(0, 0);
    for (auto x: a)
    {
        if (x + res == res)continue;
        while (ans.size() >= 2)
        {
            pt y = ans[ans.size() - 1];
            pt z = ans[ans.size() - 2];
            if ((x - y) % (y - z) >= 0)ans.pop_back();
            else break;
        }
        ans.push_back(x);
    }
    for (auto &x: ans)x += res;
    return ans;
}

struct poly
{
    int n{};
    vector<pt> a;

    poly() = default;

    poly(const vector<pt> &a) : a(convex_hull(a))
    {
        n = (int) this->a.size();
    }

    poly operator+(const poly &other) const
    {
        vector<pt> deltas;
        deltas.reserve(n + other.n);
        for (int i = 0; i < n; i++)
        {
            deltas.push_back(a[(i + 1) % n] - a[i]);
        }
        for (int i = 0; i < other.n; i++)
        {
            deltas.push_back(other.a[(i + 1) % other.n] - other.a[i]);
        }
        sort(deltas.begin(), deltas.end());
        pt res = a[0];
        for (auto i: a)
        {
            if (i.y < res.y || (i.y == res.y && i.x < res.x))res = i;
        }
        pt res2 = other.a[0];
        for (auto i: other.a)
        {
            if (i.y < res2.y || (i.y == res2.y && i.x < res2.x))res2 = i;
        }
        vector<pt> ans(n + other.n);
        pt now = res + res2;
        for (int i = 0; i < n + other.n; i++)
        {
            ans[i] = now;
            now += deltas[i];
        }
        return ans;
    }

    poly operator-() const
    {
        vector<pt> other = a;
        for (auto &i: other)i = -i;
        return other;
    }

    poly operator-(const poly &other) const
    {
        return (*this) + (-other);
    }

    ll area() const
    {
        ll area = 0;
        for (int i = 0; i < a.size(); i++)
        {
            area += a[(i + 1) % a.size()] % a[i];
        }
        return abs(area);
    }
};

istream &operator>>(istream &in, poly &a)
{
    int n;
    in >> n;
    vector<pt> res(n);
    in >> res;
    a = poly(res);
    return in;
}

ostream &operator<<(ostream &out, const poly &a)
{
    return out << a.a;
}

template<typename T>
class line
{
public:
    T a, b, c;

    line() = default;

    line(const r<T> &a, const r<T> &b) : line(
            a.y - b.y,
            b.x - a.x,
            a.x * b.y - a.y * b.x)
    {}

    line(const T &a, const T &b, const T &c)
    {
        this->a = a;
        this->b = b;
        this->c = c;
    }

    line perpendicular(const r<T> &point) const
    {
        return line(-b, a, b * point.x - a * point.y);
    }

    r<T> normal()
    {
        return {a, b};
    }

    bool operator==(const line<T> &other) const
    {
        return (a == other.a) && (b == other.b) && (c == other.c);
    }
};

template<typename T>
istream &operator>>(istream &in, line<T> &ln)
{
    in >> ln.a >> ln.b >> ln.c;
    return in;
}

template<typename T>
ostream &operator<<(ostream &out, const line<T> &ln)
{
    out << ln.a << ' ' << ln.b << ' ' << ln.c;
    return out;
}

using Line = line<ll>;

int sign(ll x)
{
    if (x < 0)return -1;
    if (x > 0)return 1;
    return 0;
}

struct Test
{
    int n{};
    poly a;

    bool check2(pt norm, pt pt1, pt pt2)
    {
        return sign(norm % pt1) * sign(norm % pt2) != -1;
    }

    bool check(pt norm, int ind)
    {
        return check2(norm, a.a[(ind + 1) % a.n] - a.a[ind], a.a[((ind - 1) + n) % n] - a.a[ind]);
    }

    Test()
    {
        cin >> a;
        n = a.n;
        int res_i = 0;
        int res_j = 0;
        ll ans = 0;
        for (int i = 0; i < n; i++)
        {
            for (int j = i + 1; j < n; j++)
            {
                line l = line(a.a[i], a.a[j]);
                pt norm = l.normal();
                ll dist = (a.a[i] - a.a[j]).size();
                if (check(norm, i) && check(norm, j) && dist > ans)
                {
                    ans = dist;
                    res_i = i;
                    res_j = j;
                }
            }
        }
        line l = line(a.a[res_i], a.a[res_j]);
        cout << l.perpendicular(a.a[res_i]) << '\n' << l.perpendicular(a.a[res_j]);

    }
};


signed main()
{
#ifdef home
    freopen(".in", "r", stdin);
    freopen(".out", "w", stdout);

    auto start = clock();
#else
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
#endif
    int t = 1;
    //cin >> t;
    cout.precision(20);
    while (t--)
    {
        Test();
    }
#ifdef home
    cerr << "Time: " << (clock() - start) * 1e3 / CLOCKS_PER_SEC << "ms\n";
#endif
}
