#include <bits/allocator.h>

#ifndef DEBUG
#pragma GCC optimize ("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")
#endif

#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;
using pll = pair<ll, ll>;
using vll = vector<ll>;
using vpl = vector<pll>;
using vbo = vector<bool>;
using vvl = vector<vll>;
using vvp = vector<vpl>;

#define all(a) a.begin(),a.end()
#define sz(a) (ll)a.size()

#define FOR(i, a, ...) for(ll i = 0 __VA_OPT__(+ (a)); i < (a) __VA_OPT__(+ __VA_ARGS__ - (a)); ++i)
#define ROF(i, a, ...) for(int i = (a - 1) __VA_OPT__(+ __VA_ARGS__ - (a)); i >= 0 __VA_OPT__(+ (a)); --i)
#define each(i, a) for(auto& i : a)

vector<char> piano;

void solve() {
    string s;
    cin >> s;
    FOR(i, 52) {
        if (piano[i] != s[0]) {
            continue;
        }
        ll p = i;
        bool ok = true;
        FOR(j, 1, s.size()) {
            bool found = false;
            FOR(k, -3, 4) {
                ll dp = p + k;
                if (p < 0 || p >= 52) {
                    continue;
                }
                if (piano[dp] == s[j]) {
                    p = dp;
                    found = true;
                    break;
                }
            }
            if (!found) {
                ok = false;
                break;
            }
        }
        if (ok) {
            cout << "Yes\n";
            return;
        }
    }
    cout << "No\n";
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    vector<char> notes = {'A', 'B', 'C', 'D', 'E', 'F', 'G'};
    piano.resize(52);
    FOR(i, 52) {
        piano[i] = notes[i % 7];
    }
    ll t;
    cin >> t;
    while (t--) {
        solve();
    }
}