#include <bits/allocator.h>

#ifndef DEBUG
#pragma GCC optimize ("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")
#endif

#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;
using pll = pair<ll, ll>;
using vll = vector<ll>;
using vpl = vector<pll>;
using vbo = vector<bool>;
using vvl = vector<vll>;
using vvp = vector<vpl>;

#define all(a) a.begin(),a.end()
#define sz(a) (ll)a.size()

#define FOR(i, a, ...) for(ll i = 0 __VA_OPT__(+ (a)); i < (a) __VA_OPT__(+ __VA_ARGS__ - (a)); ++i)
#define ROF(i, a, ...) for(int i = (a - 1) __VA_OPT__(+ __VA_ARGS__ - (a)); i >= 0 __VA_OPT__(+ (a)); --i)
#define each(i, a) for(auto& i : a)

ll dist(pll a, pll b) {
    ll dx = a.first - b.first;
    ll dy = a.second - b.second;
    return dx * dx + dy * dy;
}

struct line {
    ll a, b, c;

    line(pll& p1, pll& p2) {
        a = p2.second - p1.second;
        b = p1.first - p2.first;
        c = p1.second * (p2.first - p1.first) - p1.first * (p2.second - p1.second);
    }
};

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    ll n;
    cin >> n;
    vpl points(n);
    FOR(i, n) {
        cin >> points[i].first >> points[i].second;
    }
    ll b_i = 0, b_j = 0;
    FOR(i, n) {
        FOR(j, n) {
            if (dist(points[i], points[j]) > dist(points[b_i], points[b_j])) {
                b_i = i;
                b_j = j;
            }
        }
    }
    pll p1 = points[b_i];
    pll p2 = points[b_j];
    pll norm = {p2.first - p1.first, p2.second - p1.second};
    pll dir = {norm.second, -norm.first};
    pll p1_s = {p1.first + dir.first, p1.second + dir.second};
    pll p2_s = {p2.first + dir.first, p2.second + dir.second};
    line l1 = line(p1, p1_s);
    line l2 = line(p2, p2_s);
    cout << l1.a << ' ' << l1.b << ' ' << l1.c << '\n';
    cout << l2.a << ' ' << l2.b << ' ' << l2.c << '\n';
}