#include <bits/allocator.h>

#ifndef DEBUG
#pragma GCC optimize ("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")
#endif

#include <bits/stdc++.h>

using namespace std;

using ll = long long;

const ll MOD = 1e9 + 7;


struct mint {
    int x = 0;

    mint() {}

    mint(ll _x) : x(_x % MOD) {}

    mint& operator+=(mint other) {
        x += other.x;
        x -= x >= MOD ? MOD : 0;
        return *this;
    }

    mint& operator-=(mint other) {
        x += MOD - other.x;
        x -= x >= MOD ? MOD : 0;
        return *this;
    }

    mint& operator*=(mint other) {
        x = (long long) x * other.x % MOD;
        return *this;
    }

    mint operator+(mint other) const {
        mint res = *this;
        res += other;
        return res;
    }

    mint operator-(mint other) const {
        mint res = *this;
        res -= other;
        return res;
    }

    mint operator*(mint other) const {
        mint res = *this;
        res *= other;
        return res;
    }

    std::weak_ordering operator<=>(const mint& other) const {
        return x <=> other.x;
    }

    mint bin_pow(ll n) const {
        if (n == 0) {
            return 1;
        }
        if (n % 2 == 1) {
            return *this * bin_pow(n - 1);
        }
        mint h = bin_pow(n / 2);
        return h * h;
    }

    mint rev() const {
        return bin_pow(MOD - 2);
    }

    mint& operator/=(const mint& other) {
        *this *= other.rev();
        return *this;
    }

    mint operator/(const mint& other) const {
        mint res = *this;
        res /= other;
        return res;
    }
};

mint bp(mint a, ll p) {
    if (!p) return 1;
    if (p & 1) return a * bp(a, p - 1);
    mint k = bp(a, p / 2);
    return k * k;
}
signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    ll t;
    cin >> t;
    while (t--) {
        ll m, p;
        cin >> p >> m;
        mint ans = 0;
        mint n = mint(m + p - 1);
        ans += n * (n + 1) * (n * 2 + 1) * mint(6).rev();
        ans += n * (n + 1) * mint(2).rev() * 3;
        ans += n * 2;
        ans += 2;
        ans *= 2;
        ans *= mint(n + 1).rev();
        ans *= mint(n + 2).rev();
        ans *= p;
        ans *= bp(2, p - 1);
        cout << ans.x << endl;
    }
}
