#define _GLIBCXX_DEBUG 1
//#define _CRT_SECURE_NO_WARNINGS

/*
#pragma GCC optimize("Ofast")
#pragma GCC optimize("unroll-loops")
#pragma GCC optimize("inline")
*/

#include<bits/stdc++.h>
#include<ext/pb_ds/assoc_container.hpp>
#include<ext/pb_ds/tree_policy.hpp>

using namespace std;
using namespace __gnu_pbds;

#define int long long
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()

#ifdef LOCAL
#define debug(x) cerr << "[line:" << __LINE__ << "] " << #x << " = " << x << '\n'
#else
#define debug(x) 42
#endif

typedef long double ld;
typedef long long ll;
typedef unsigned long long ull;
typedef tree<int, null_type, less_equal<int>, rb_tree_tag, tree_order_statistics_node_update> ordered_set;

const int INF = 9e18;
const int inf = 2e9;
const int MOD = 1e9 + 7;
const int FFT_MOD = 998244353;
const ld EPS = 1e-14;
const ld PI = acos(-1);

mt19937 rng(42239777);

ld ld_rng(){
    return (ld) rng() / rng.max();
}

template <typename T>
istream& operator >> (istream& in, pair<T, T> &a){
    return in >> a.first >> a.second;
}

template <typename T>
ostream& operator << (ostream& out, pair<T, T> a){
    return out << a.first << " " << a.second;
}

template <typename T>
istream& operator >> (istream& in, vector<T> &a){
    for (int i = 0; i < a.size(); ++i){
        in >> a[i];
    }
    return in;
}

template <typename T>
ostream& operator << (ostream& out, vector<T> a){
    for (int i = 0; i < a.size(); ++i){
        out << a[i] << " ";
    }
    return out;
}

template <typename T>
ostream& operator << (ostream& out, vector<vector<T>> a){
    for (int i = 0; i < a.size(); ++i){
        for (int j = 0; j < a[i].size(); ++j){
            out << a[i][j] << " ";
        }
        out << "\n";
    }
    return out;
}

void read_graph(int m, vector<vector<int>> &g){
    for (int i = 0; i < m; ++i){
        int v, u;
        cin >> v >> u;
        v--;
        u--;
        g[v].push_back(u);
        g[u].push_back(v);
    }
}

template <typename T>
void print_graph(vector<vector<T>> g){
    for (int i = 0; i < g.size(); ++i){
        cout << i << ":  " << g[i] << "\n";
    }
}

void solve(){
    int n;
    cin >> n;
    vector<vector<int>> hex(2 * n - 1);
    for (int i = 0; i < n; ++i){
        hex[i].resize(n + i);
    }
    for (int i = n; i < 2 * n - 1; ++i){
        hex[i].resize(2 * n - 1 - i + n - 1);
    }
    for (int i = 0; i < 2 * n - 1; ++i){
        cin >> hex[i];
    }

    vector<vector<int>> layers(n);
    vector<deque<int>> dq(2 * n - 1);
    for (int i = 0; i < dq.size(); ++i){
        for (int j : hex[i]){
            dq[i].push_back(j);
        }
    }


    for (int l = 0; l < n; ++l){
        for (int i = n - 1; i > l; --i){
            layers[l].push_back(dq[i].front());
            dq[i].pop_front();
        }
        while (!dq[l].empty()){
            layers[l].push_back(dq[l].front());
            dq[l].pop_front();
        }
        for (int i = l + 1; i < 2 * n - 1 - l; ++i){
            layers[l].push_back(dq[i].back());
            dq[i].pop_back();
        }
        while (!dq[2 * n - 2 - l].empty()){
            layers[l].push_back(dq[2 * n - 2 - l].back());
            dq[2 * n - 2 - l].pop_back();
        }
        for (int i = 2 * n - 3 - l; i >= n; --i){
            layers[l].push_back(dq[i].front());
            dq[i].pop_front();
        }
    }

    string query;
    cin >> query;
    bool rev = false;
    int delta = 0;
    for (char c : query){
        if (c == 'T') {
            rev = !rev;
        } else if (c == 'R'){
            if (!rev){
                delta++;
            } else {
                delta--;
            }
        } else if (c == 'L'){
            if (!rev){
                delta--;
            } else {
                delta++;
            }
        }
    }

    auto new_layers = layers;
    for (int l = 0; l < n; ++l){
        for (int i = 0; i < layers[l].size(); ++i){
            new_layers[l][i] = layers[l][(i - delta * (n - 1 - l) + inf * layers[l].size()) % layers[l].size()];
        }
    }
    layers = new_layers;

    auto res = hex;
    for (int i = 0; i < res.size(); ++i){
        for (int j = 0; j < res[i].size(); ++j){
            res[i][j] = 0;
        }
    }

    for (int l = 0; l < n - 1; ++l){
        int idx = 0;
        for (int i = n - 1; i > l; --i){
            res[i][l] = layers[l][idx++];
        }
        for (int j = l; j < n; ++j){
            res[l][j] = layers[l][idx++];
        }
        for (int i = l + 1; i < 2 * n - 2 - l; ++i){
            res[i][res[i].size() - l - 1] = layers[l][idx++];
        }

        for (int j = n - 1; j >= l; --j) {
            res[2 * n - 2 - l][j] = layers[l][idx++];
        }

        for (int i = 2 * n - 3 - l; i >= n; --i) {
            res[i][l] = layers[l][idx++];
        }
    }
    res[n - 1][n -1] = layers.back().back();
    if (rev) {
        for (int i = 0; i < res.size(); ++i) {
            reverse(all(res[i]));
        }
    }
    cout << res;
}

/*
3
4 1 8
3 5 1 7
2 1 6 1 8
1 7 1 9
8 9 9
LTR

4
 1 2 3 4
 18 1 2 3 5
 17 12 1 2 4 6
 16 11 6 1 3 5 7
 15 10 5 4 6 8
 14 9 8 7 9
 13 12 11 10
 */

int32_t main(){
    ios::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
    cout << fixed << setprecision(15);

    int _ = 1;
    //cin >> _;
    while (_--){
        solve();
    }

    return 0;
}
/*

*/