#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
#include <set>

using namespace std;

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    int t;
    cin >> t;
    while(t--) {
        int n;
        cin >> n;
        vector<pair<string, string>> ss(n);
        map<string, set<string>> fsts, snds;
        
        for(int i = 0; auto& [fst, snd] : ss) {
            cin >> fst >> snd;

            if(i++ > 0) {
            fsts[fst].insert(snd);
            snds[snd].insert(fst);
            }
        }
        
        bool can = true;
        for(size_t i = 1; i < n; i++) {
            auto& [pf, ps] = ss[i - 1];
            auto& [f, s] = ss[i];

            if(f != pf && s != ps) {
                if (!fsts[pf].empty() || !snds[ps].empty()) {
                    can = false;
                    break;
                }
            }

            fsts[f].erase(s);
            snds[s].erase(f);
        }

        cout << (can ? "Yes\n" : "No\n");
    }
    return 0;
}