#include <bits/stdc++.h>

using namespace std;
#define ll long long

ll my_hash(string &s) {
    return std::hash<std::string>{}(s);
}

void add(string &s, int i, map<string, ll> &map) {
    if (!map.contains(s)) {
        map[s] = i;
//        cout << s << " = " << i << '\n';
    }
}

void debug(map<string, ll> &m1, map<string, ll> &m2, ll pos, ll i) {
    cout << "pos = " << pos << " i = " << i << '\n';
    cout << " ==== m1 ===== \n";
    for (auto& [k,v]: m1) {
        cout << k << ' ' << v << '\n';
    }
    cout << " ==== m2 ===== \n";
    for (auto& [k,v]: m2) {
        cout << k << ' ' << v << '\n';
    }
}

struct MapIntersect {
    map<string, int> cnt_left;
    map<string, int> cnt_right;
    set<string> real_intersect;

    void add_to_left(const string& a) {
        cnt_left[a] = 1;
//        if (a == "shaped") {
//            std::cout << a << ' ' <<  cnt_right[a] << ' ' << cnt_left[a] << std::endl;
//        }
        if (cnt_right.contains(a) && cnt_right[a] > 0) {
            real_intersect.insert(a);
        }
    }

    void remove_from_right(const string& a) {
        if (cnt_right[a] != 1) {
            cnt_right[a]--;
            return;
        }

        cnt_right.erase(a);
        if (real_intersect.contains(a)) {
            real_intersect.erase(a);
        }
    }

    bool not_empty() const {
        return real_intersect.size() > 0;
    }
};

void solve() {
    int n;
    cin >> n;

    MapIntersect fst, snd;
    vector<pair<string, string>> all_words(n);
    for (auto &[a, b] : all_words) {
        cin >> a >> b;
        fst.cnt_right[a]++;
        snd.cnt_right[b]++;
    }

    fst.remove_from_right(all_words[0].first);
    snd.remove_from_right(all_words[0].second);

    fst.add_to_left(all_words[0].first);
    snd.add_to_left(all_words[0].second);

    for (int i = 1; i < n; ++i) {
        auto &[l, r] = all_words[i];
        fst.remove_from_right(l);
        snd.remove_from_right(r);
//        if (i == 2) {
//            std::cout << fst.cnt_left["a"] << std::endl;
//            std::cout << fst.cnt_right["a"] << std::endl;
//            std::cout << fst.real_intersect.size() << std::endl;
//        }
//        std::cout << i << ' ' << snd.cnt_left[r] << ' ' << snd.cnt_right[r] << std::endl;
        if (fst.cnt_left[l] == 0 && snd.cnt_left[r] == 0) {
            if (fst.not_empty() || snd.not_empty()) {
//                std::cout << i << ' ' << fst.real_intersect.size() << ' ' << snd.real_intersect.size() << std::endl;
                std::cout << "No\n";
                return;
            }
        }

        fst.add_to_left(l);
        snd.add_to_left(r);
    }
    std::cout << "Yes\n";
}


signed main() {
    freopen("../input.txt", "r", stdin);

    int n;
    cin >> n;
    while (n--) {
        solve();
    }
}