#include <iostream>
#include <algorithm>
#include <vector>
#include <cassert>
#include <unordered_set>

using namespace std;


using ll = long long;
#define forn(i, n) for(ll i = 0; i < (n); ++i)

constexpr ll mod1 = 1e9 + 7, mod2 = 1e9 + 9;

ll bin_pow(ll x, ll p, ll mod) {
    ll res = 1;
    while (p) {
        if (p & 1) {
            res = res * x % mod;
        }
        x = x * x % mod;
        p /= 2;
    }
    return res;
}

ll inv(ll x, ll mod) {
    return bin_pow(x, mod - 2, mod);
}

ll div(ll x, ll y, ll mod) {
    return x * inv(y, mod) % mod;
}

void solve() {
    int n;
    cin >> n;
    int res = 1;
    vector<pair<string, string>> a(n);
    for (int i = 0; i < n; i++){
        cin >> a[i].first >> a[i].second;
    }
    unordered_set<string> s1, s2;
    string x, y;
    x = a[n-1].first;
    y = a[n-1].second;
    s1.insert(x);
    s2.insert(y);
    for (int i = n-2; i >=0; i--){
        if (!(a[i].first == x || a[i].second == y)){
            if ((s1.find(a[i].first) != s1.end()) || (s2.find(a[i].second) != s2.end())) {
                res = 0;
                break;
            }
        }
        x = a[i].first;
        y = a[i].second;
        s1.insert(x);
        s2.insert(y);
    }
    if (res) {
        cout << "Yes\n";
    } else {
        cout << "No\n";
    }
}

int main() {
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}


