#include <bits/stdc++.h>
using namespace std;
using ll = long long;

#include <bits/stdc++.h>
using namespace std;
using ll = long long;

constexpr ll mod = 998244353, root = 31, pw = 1 << 23;
vector<vector<ll>> w;

inline ll mult(ll a, ll b) { return a * b % mod; }
inline ll add(ll a, ll b) { return (a + b < mod ? a + b : a + b - mod);}
inline ll sub(ll a, ll b) { return (a >= b ? a - b : a - b + mod); }

ll binpow(ll a, ll b) {
    ll ans = 1;
    while (b) {
        if (b & 1)
            ans = mult(ans, a);
        a = mult(a, a);
        b >>= 1;
    }
    return ans;
}

template<bool inv = false>
void fft(vector<ll> &P) {
    int n = ssize(P);
    int lg = bit_width((unsigned)n) - 1;
    vector<int> bit_rev(n);
    bit_rev[0] = 0;
    for (int i = 1; i < n; i++) {
        bit_rev[i] = (bit_rev[i >> 1] >> 1) + ((i & 1) << (lg - 1));
    }
    for (int i = 0; i < n; i++) {
        if (i < bit_rev[i])
            swap(P[i], P[bit_rev[i]]);
    }
    for (int lvl = 1; lvl <= lg; lvl++) {
        for (int i = 0; i < n; i += (1 << lvl)) {
            int d = 1 << (lvl - 1);
            for (int j = 0; j < d; j++) {
                ll u = mult(w[lvl][j], P[i + j + d]);
                P[i + j + d] = sub(P[i + j], u);
                P[i + j] = add(P[i + j], u);
            }
        }
    }
    if constexpr (inv) {
        reverse(P.begin() + 1, P.end());
        ll invn = binpow(n, mod - 2);
        for (int i = 0; i < n; i++) {
            P[i] = mult(P[i], invn);
        }
    }
}

void precompute_roots(int lg) {
    int old = ssize(w) - 1;
    if (old >= lg)
        return;
    w.resize(lg + 1);
    for (int l = old + 1; l <= lg; l++) {
        if (l == 0) {
            w[0] = {1};
            continue;
        }
        int n = (1 << l);
        w[l].resize(n / 2);
        ll wcur = binpow(root, pw / n);
        for (int j = 0; j < n / 2; j++) {
            if (j & 1) {
                w[l][j] = mult(w[l - 1][j >> 1], wcur);
            } else {
                w[l][j] = w[l - 1][j >> 1];
            }
        }
    }
}

vector<ll> multiply(vector<ll> P, vector<ll> Q) {
    int lg = bit_width(size(P) + size(Q) - 2);
    int n = 1 << lg;
    precompute_roots(lg);
    P.resize(n);
    Q.resize(n);
    fft(P);
    fft(Q);
    vector<ll> R(n);
    for (int j = 0; j < n; j++) {
        R[j] = mult(P[j], Q[j]);
    }
    fft<true>(R);
    return R;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, k;
    cin >> n >> k;
    vector<ll> a = {1};
    vector<vector<ll>> his = {a};
    for (int j = 2; j <= k; j++) {
        vector<ll> b((1 << (j - 1)) * j + 1, 0);
        for (int i = 2; i <= j + 1; i++) {
            for (int h = (1 << i) * (i - 2); h <= (1 << i) * (i - 1); h += 4)
                b[h >> 2] = 1;
        }
        b[(1 << (j - 1)) * j] = 0;
        b[0] = 1;
        a = multiply(a, b);
        for (int i = 0; i < ssize(a); i++) {
            if (a[i] != 0)
                a[i] = 1;
        }
        his.push_back(a);
    }
    vector<vector<int>> next(size(his));
    for (int i = 0; i < ssize(his); i++) {
        next[i].resize(size(his[i]));
        int t = INT_MAX;
        for (int j = ssize(his[i]) - 1; j >= 0; j--) {
            if (his[i][j] == 1) {
                t = j;
            }
            next[i][j] = t;
        }
    }
    for (int _ = 0; _ < n; _++) {
        int v;
        cin >> v;
        if (v % 4 != 0) {
            cout << "-1\n";
            continue;
        }
        v /= 4;
        if (a[v] == 0) {
            cout << "-1\n";
            continue;
        }
        vector<int> ans;

        int ni = ssize(next);
        for (int j = k; j >= 2; j--) {
            ni--;
            for (int i = j + 1; i >= 2; i--) {
                int l = (1 << (i - 2)) * (i - 2);
                int r = (1 << (i - 2)) * (i - 1);
                if (i == j + 1)
                    r--;
                if (0 <= v - r && ssize(next[ni - 1]) > v - r && next[ni - 1][v - r] <= v - l) {
                    v = next[ni - 1][v - r];
                    ans.push_back(1 << i);
                    break;
                }
            }
            if (v == 0)
                break;
        }
        cout << size(ans) << " ";
        for (int i : ans) {
            cout << i << " ";
        }
        cout << "\n";
    }
}