#include <bits/stdc++.h>

using namespace std;

/* G draft
void dfs(int v, vector<vector<int> > &g, vector<int> &color, int col, int &sz, int &mx)
{
    color[v] = col;
    sz++;
    mx = max(mx, v);
    for (auto u : g[v]) if (color[u] == -1) {
        dfs(u, g, color, col, sz, mx);
    }
}

void solve()
{
    int n, m;
    cin >> n >> m;
    vector<vector<int> > g(n);
    for (int i = 0; i < m; i++) {
        int f, t;
        cin >> f >> t;
        f--, t--;
        g[f].push_back(t);
        g[t].push_back(f);
    }

    vector<int> color(n, -1);
    vector<int> maxForColor(n);
    int col = 0;
    for (int i = 0; i < n; i++) {
        if (color[i] == -1) {
            int sz = 0;
            int mx = -1;
            dfs(i, g, color, col, sz, mx);
            if (sz % 2 == 1) {
                cout << -1 << "\n";
                return;
            }
            maxForColor[col] = mx;
            col++;
        }
    }

    for (int i = 0; i < n; i++) {
        cout << maxForColor[color[i]] + 1 << " ";
    }
    cout << "\n";
}
*/

/* L draft
const int M = 1000000;
const int OPS = 1000000;
mt19937 rnd;

void solve()
{
    int n, k, d;
    cin >> n >> k >> d;
    double base_ans = n * d / 2.0 + 0.5;
    double c = 1.0 * (k - 1) / (n - 1);

    double sum = 0;
    for (int i = 0; i < OPS; i++) {
        double cur = 0;
        int temp = k - 1;
       // cout << setprecision(20) << cur << "\n";
        for (int j = 0; j < n - 1; j++) {
            int r = (rnd() % M + M) % M;
            double R = 1.0 * r / M;
            // printf("%.9f\n", R);
            cur = R;
            if (cur > 1) {
                cur -= 1;
            }
            // cout << setprecision(20) << cur << "\n";
            if (cur <= c && temp) {
                temp--;
                sum += 1 - cur;
                cur = 0;
            }
        }
        // cout << sum << " " << temp << "\n";
    }
    cout << setprecision(20) << (n - 1) * (1 - c) * c << "\n";
    cout << setprecision(20) << sum / OPS << "\n";

    cout << setprecision(20) << base_ans << " " << c << "\n";
}

*/

struct op {
    char type;
    int v;
    int isAsync;
};

const int LIMIT = 1e6 + 1;

void solve() {
    int n;
    cin >> n;
    vector<op> ops(n + 2);
    ops[0] = { '=', 0, 0 };
    for (int i = 1; i <= n; i++) {
        cin >> ops[i].type >> ops[i].v;
        string s;
        cin >> s;
        if (s == "async") {
            ops[i].isAsync = 1;
        }
    }
    ops[n + 1] = { '+', 0, 0 };
    
    {
        int lastSyncSet = 0;
        for (int i = 1; i <= n; i++) {
            if (!ops[i].isAsync && ops[i].type == '=') {
                lastSyncSet = i;
            }
        }

        vector<op> simplified;
        for (int i = 0; i <= n + 1; i++) {
            if (ops[i].isAsync) {
                simplified.push_back(ops[i]);
            } else {
                if (i >= lastSyncSet) {
                    simplified.push_back(ops[i]);
                }
            }
        }
        ops = simplified;
    }

    int m = ops.size();
    // cout << "\n";
    // for (int i = 0; i < m; i++) {
    //     cout << ops[i].type << " " << ops[i].v << " " << ops[i].isAsync << "\n";
    // }

    bitset<LIMIT> sums, ans;
    vector<int> starts;
    int flag = 0;
    sums.set(0);
    for (int idFirstSync = 0; idFirstSync < m; idFirstSync++) {
        if (ops[idFirstSync].isAsync) {
            if (ops[idFirstSync].type == '+') {
                sums |= sums << ops[idFirstSync].v;
            } else {
                starts.push_back(ops[idFirstSync].v);
            }
            continue;
        }
        int bad = 0;
        for (int i = idFirstSync; i < m; i++) {
            if (ops[i].isAsync && ops[i].type == '=') {
                bad = 1;
            }
        }
        if (bad == 1) {
            continue;
        }

        // cout << "! " << ops[idFirstSync].type << " " << ops[idFirstSync].v << " " << ops[idFirstSync].isAsync << "\n";
        if (ops[idFirstSync].type == '=') {
            int sufsum = 0;
            for (int i = idFirstSync; i < m; i++) {
                sufsum += ops[i].v;
            }
            ans |= sums << sufsum;
        } else {
            if (!flag) {
                flag = 1;
                bitset<LIMIT> sumsNew;
                for (auto e : starts) {
                    sumsNew |= sums << e;
                }
                sums = sumsNew;
            }
            int sufsum = 0;
            for (int i = idFirstSync; i < m; i++) {
                sufsum += ops[i].v;
            }
            ans |= sums << sufsum;
        }
    }
    cout << ans.count() << "\n";
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    auto time1 = std::chrono::high_resolution_clock::now().time_since_epoch().count();
    int t = 1;
    // cin >> t;
    while (t--) {
        solve();
    }
    auto time2 = std::chrono::high_resolution_clock::now().time_since_epoch().count();
    // cout << (time2 - time1) / 1e9 << "\n";
}