#include <vector>
#include <string>
#include <iostream>
#include <set>
#include <map>
#include <algorithm>

using namespace std;

using ll = long long;
using vi = vector<ll>;
using vvi = vector<vi>;

const ll INF = (ll) 1e18;

void solve() {
    int n; cin >> n;
    vector<pair<string, string>> ss;
    map<string, vector<pair<string, int>>> as, bs;
    for(int i=0; i<n; ++i) {
        string a, b; cin >> a >> b;
        as[a].emplace_back(b, i);
        bs[b].emplace_back(a, i);
        ss.emplace_back(a, b);
    }
    
    set<string> used_a, used_b;
    set<pair<string, string>> awaiting;
    int max_i = 0;
    for(int i=0; i<n; ++i) {
        string a = ss[i].first, b = ss[i].second;
        if(awaiting.find({a, b}) == awaiting.end() && max_i > i) {
            cout << "No\n";
            return;
        }
        if (used_a.find(a) == used_a.end()) {
            for(auto&[new_b, j] : as[a]) {
                awaiting.insert({a, new_b});
                max_i = max(max_i, j);
            }
            used_a.insert(a);
        }
        if (used_b.find(b) == used_b.end()) {
            for(auto&[new_a, j] : bs[b]) {
                awaiting.insert({new_a, b});
                max_i = max(max_i, j);
            }
            used_b.insert(b);
        }
    }
    cout << "Yes\n";
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    
    int t = 1;
    cin >> t;
    while(t--) {
        solve();
    }
}