#include <iostream>
#include <vector>
#include <set>
#include <string>
#include <iterator>

using namespace std;

using ll = long long;

int main()
{
	string s, c;
	cin >> s >> c;
	const int x = s.size();
	const int y = c.size();
	const int c_exp = y - 1;
	const auto c_leading = double(c[0] - '0');
	constexpr double bad{ 100.0 };

	auto consider = [&](int a_length) -> double {
		if (a_length <= 0) return bad;
		if (a_length >= x) return bad;
		int a_exp = a_length - 1, b_exp = x - a_length - 1;
		if (s[0] == '0') return bad;
		if (s[a_length] == '0') return bad;
		auto a_leading = double(s[0] - '0');
		auto b_leading = double(s[a_length] - '0');
		return b_leading * c_leading / a_leading * pow(10.0, b_exp + c_exp - a_exp);
	};

	const int initial_guess{ (x + y) / 2 };
	int best_length = -1;
	double best_score{ bad };
	for (int i = -2; i < 3; i++) {
		int guess = initial_guess + i;
		double score = consider(guess);
		if (abs(score - 1.0) > abs(best_score - 1.0)) continue;
		best_score = score;
		best_length = guess;
	}
	copy_n(s.begin(), best_length, ostream_iterator<char>(cout));
	cout << " ";
	copy(s.begin() + best_length, s.end(), ostream_iterator<char>(cout));

	return 0;
}