#include <iostream>
#include <algorithm>
#include <vector>
#include <map>
#include <set>
#include <random>
#include <cassert>
using namespace std;

mt19937 rng(0);

bool is_black(int x, int y) {
    cout << "? " << x << " " << y << endl;
    char res;
    cin >> res;
    return res == 'B';
}

vector<pair<int, int>> neighbours(pair<int, int> p) {
    vector<pair<int, int>> ngs;
    for (int di = -1; di <= 1; ++di) {
        for (int dj = -1; dj <= 1; ++dj) {
            if (di == 0 && dj == 0) {
                continue;
            }
            ngs.emplace_back(p.first + di, p.second + dj);
        }
    }
    return ngs;
}

struct DSU {
    map<pair<int, int>, pair<int, int>> parent;
    map<pair<int, int>, int> sz;
    pair<int, int> get_root(pair<int, int> x) {
        pair<int, int> r = x;
        while (parent.count(r) && parent[r] != r) {
            r = parent[r];
        }
        while (x != r) {
            pair<int, int> nxt = parent[x];
            parent[x] = r;
            x = nxt;
        }
        return r;
    }
    void merge(pair<int, int> x, pair<int, int> y) {
        x = get_root(x);
        y = get_root(y);
        if (x == y) {
            return;
        }
        if (!sz.count(x)) {
            sz[x] = 1;
        }
        if (!sz.count(y)) {
            sz[y] = 1;
        }
        if (sz[x] > sz[y]) {
            sz[x] += sz[y];
            parent[y] = x;
        }
        else {
            sz[y] += sz[x];
            parent[x] = y;
        }
    }
    int comp_size(pair<int, int> x) {
        x = get_root(x);
        if (!sz.count(x)) {
            return 1;
        }
        else {
            return sz[x];
        }
    }
};

void dfs(pair<int, int> curr, pair<int, int> comp, set<pair<int, int>>& visited, DSU& dsu, vector<pair<int, int>>& the_set, int n) {
    visited.insert(curr);
    //cout << curr.first << ' ' << curr.second << endl;
    if (the_set.size() < n) {
        the_set.emplace_back(curr);
    }
    else {
        return;
    }
    for (pair<int, int> ng : neighbours(curr)) {
        if (!visited.count(ng) && dsu.get_root(ng) == dsu.get_root(comp)) {
            dfs(ng, comp, visited, dsu, the_set, n);
        }
    }
}

int n;
void solve() {
    set<pair<int, int>> black;
    set<pair<int, int>> white;
    vector<pair<int, int>> known;
    known.emplace_back(0, 0);
    if (is_black(0, 0)) {
        black.insert({0, 0});
    }
    else {
        white.insert({0, 0});
    }
    pair<int, int> comp;
    DSU dsu_black, dsu_white;
    while (true) {
        //cout << known.size() << endl;
        int i = rng() % known.size();
        bool has_unknown = false;
        bool answered = false;
        for (pair<int, int> ng : neighbours(known[i])) {
            if (black.count(ng) || white.count(ng)) {
                continue;
            }
            has_unknown = true;
            bool b = is_black(ng.first, ng.second);
            known.emplace_back(ng);
            if (b) {
                black.insert(ng);
                for (pair<int, int> ng2 : neighbours(ng)) {
                    if (black.count(ng2)) {
                        dsu_black.merge(ng, ng2);
                    }
                }
                if (dsu_black.comp_size(ng) >= n) {
                    comp = ng;
                    answered = true;
                    break;
                }
            }
            else {
                white.insert(ng);
                for (pair<int, int> ng2 : neighbours(ng)) {
                    if (white.count(ng2)) {
                        dsu_white.merge(ng, ng2);
                    }
                }
                if (dsu_white.comp_size(ng) >= n) {
                    comp = ng;
                    answered = true;
                    break;
                }
            }
        }
        if (answered) {
            break;
        }
        if (!has_unknown) {
            swap(known[i], known.back());
            known.pop_back();
        }
    }
    vector<pair<int, int>> the_set;
    if (black.count(comp)) {
        set<pair<int, int>> visited = white;
        dfs(comp, comp, visited, dsu_black, the_set, n);
    }
    else {
        set<pair<int, int>> visited = black;
        dfs(comp, comp, visited, dsu_white, the_set, n);
    }
    cout << "! ";
    if (black.count(comp)) {
        cout << "B ";
    }
    else {
        cout << "W ";
    }
    //cassert(the_set.size() == n);
    for (pair<int, int> p : the_set) {
        cout << p.first << ' ' << p.second << ' ';
    }
    cout << endl;

}// TIP To <b>Run</b> code, press <shortcut actionId="Run"/> or click the <icon src="AllIcons.Actions.Execute"/> icon in the gutter.
int main() {
    // TIP Press <shortcut actionId="RenameElement"/> when your caret is at the <b>lang</b> variable name to see how CLion can help you rename it.
    cin.tie(nullptr);
    ios_base::sync_with_stdio(false);
    int t;
    cin >> t >> n;
    for (int i = 0; i < t; ++i) {
        solve();
    }

    return 0;
    // TIP See CLion help at <a href="https://www.jetbrains.com/help/clion/">jetbrains.com/help/clion/</a>. Also, you can try interactive lessons for CLion by selecting 'Help | Learn IDE Features' from the main menu.
}