#include <bits/stdc++.h>

using namespace std;

string bin(int n) {
    string ret = "";
    while (n) {
        ret += '0' + n % 2;
        n /= 2;
    }
    reverse(ret.begin(), ret.end());
    return ret;
}

int from_bin(string bn) {
    int n = 0;
    int cur = 1;
    for (int i = bn.size() - 1; i >= 0; i--) {
        n += (bn[i] - '0') * cur;
        cur <<= 1;
    }

    return n;
}

bool check(map<pair<int, int>, char> table, pair<int, int> idx) {
    bool black = false, white = false;
    if (table.find(idx) != table.end()) return false;
    for (int i = idx.first - 1; i <= idx.first + 1; ++i) {
        for (int j = idx.second - 1; j <= idx.second + 1; ++j) {
            if (table.find({i, j}) == table.end()) continue;
            black = black || (table[{i, j}] == 'B');
            white = white || (table[{i, j}] == 'W');
        }
    }
    return black && white;
}

void E() {
    int t, n; cin >> t >> n;
    while (t--) {
        bool both = false;
        set<pair<int, int>> whites, blacks;
        map<pair<int, int>, char> table;
        cout << "? " << 0 << ' ' << 0 << endl;
        pair<int, int> prev = {0, 0};
        char prevcol;

        char col; cin >> col;
        prevcol = col;
        table[{0, 0}] = col;
        if (col == 'W') {
            whites.insert({0, 0});
        } else blacks.insert({0, 0});
        while (!both && whites.size() < n && blacks.size() < n) {
            cout << "? " << prev.first + 1 << ' ' << prev.second << endl;
            prev.first += 1;
            cin >> col;
            table[prev] = col;
            if (col != prevcol) both = true;
            prevcol = col;
            if (col == 'W') {
                whites.insert({prev.first, prev.second});
            } else blacks.insert({prev.first, prev.second});
        }
        while(whites.size() < n && blacks.size() < n) {
            bool stop = false;
            for (int i = -1; i <= 1; i++) {
                if (stop) break;
                for (int j = -1; j <= 1; j++) {
                    if (i == j && i == 0) continue;
                    if (check(table, {prev.first + i, prev.second + j})) {
                        prev = {prev.first + i, prev.second + j};
                        stop = true;
                    }
                }
            }
            if (!stop) {
                for (auto u : whites) {
                    if (stop) break;
                    for (int i = -1; i <= 1; i++) {
                        if (stop) break;
                        for (int j = -1; j <= 1; j++) {
                            if (check(table, {prev.first + i, prev.second + j})) {
                                prev = {prev.first + i, prev.second + j};
                                stop = true;
                                break;
                            }
                        }
                    }
                }
            }
            if (!stop) {
                for (auto u : blacks) {
                    if (stop) break;
                    for (int i = -1; i <= 1; i++) {
                        if (stop) break;
                        for (int j = -1; j <= 1; j++) {
                            if (check(table, {prev.first + i, prev.second + j})) {
                                prev = {prev.first + i, prev.second + j};
                                stop = true;
                                break;
                            }
                        }
                    }
                }
            }

            cout << "? " << prev.first << ' ' << prev.second << endl;
            cin >> col;
            prevcol = col;
            if (col == 'W') {
                whites.insert(prev);
            } else blacks.insert(prev);
            table[prev] = col;
        }

        if (whites.size() == n) {
            cout << "! W ";
            for (auto [f, s]: whites) cout << f << ' ' << s << ' ';
            cout << endl;
        } else {
            cout << "! B ";
            for (auto [f, s]: blacks) cout << f << ' ' << s << ' ';
            cout << endl;
        }
    }
}

void C() {
    int n; cin >> n;
    if (n == 0) {
        cout << 0 << "\n";
        return;
    }
    //cout << 1 << endl;
    string bn = bin(n);
    //cout << 2 << endl;
    while (bn.size() % 7 != 0) {
        bn = '0' + bn;
    }
    vector<string> ans;

    int sz = bn.size();
    int anssize = sz / 7;
    for (int i = 0; i < anssize; ++i) {
        //cout << i << endl;
        string cur = "";
        for (int j = 0; j < 7; j++) {
            cur += bn[i * 7 + j];
        }
        ans.push_back(cur);
    }
    //cout << 3 << endl;

    for (int i = 0; i < ans.size(); i++) {
        string bn = (i == ans.size() - 1 ? '0' : '1') + ans[i];
        cout << from_bin(bn) << " ";
    }
    cout << "\n";
}

void J() {
    int n;
    cin >> n;
    vector<pair<string, string> > a(n);
    map<string, int> fi, se;
    for(int i = 0; i < n; ++i) {
        cin >> a[i].first >> a[i].second;
        fi[a[i].first]++;
        se[a[i].second]++;
    }
    pair<string, string> prev, cur;
    prev = a[0];
    bool ok = true;
    fi[prev.first]--;
    se[prev.second]--;
    for (int i = 1; i < n; ++i) {
        cur = a[i];
        if (cur.first == prev.first || cur.second == prev.second) ok = ok;
        else {
            if (fi[prev.first] > 0 || se[prev.second] > 0) {
                cout << "No\n";
                return;
            }
        }
        fi[cur.first]--;
        se[cur.second]--;
        prev = cur;
    }
    if (ok) cout << "Yes\n";
    else cout << "No\n";
}

void D() {
    vector<int> num(3);
    cin >> num[0] >> num[1] >> num[2];
    vector<int> order = {0, 1, 2};
    if (num[0] < num[1]) {
        swap(num[0], num[1]);
        swap(order[0], order[1]);
    }
    if (num[0] < num[2]) {
        swap(num[0], num[2]);
        swap(order[0], order[2]);
    }
    if (num[1] < num[2]) {
        swap(num[1], num[2]);
        swap(order[1], order[2]);
    }
    int n = 5000;
    vector<string> ans(3);
    for (int i = 0; i < 3; ++i) {
        ans[i] = "";
        for(int j = 0; j < n; ++j) ans[i] += 'a';
    }
    for(int i = 0; i < num[0]; ++i) {
        ans[1][i] = 'b';
    }
    for(int i = 0; i < num[1]; ++i) {
        ans[2][i] = 'b';
    }
    if (num[2] < num[0] - num[1]) {
        cout << "No\n";
        return;
    }
    for(int i = 0; i < num[2] - (num[0] - num[1]); ++i) {
        ans[2][i] = 'c';
    }

    int diff = 0;
    for (int i = 0; i < n; ++i) {
        diff += (ans[0][i] != ans[1][i]);
    }
    if (diff != num[0]) {
        cout << "No\n";
        return;
    }
    diff = 0;
    for (int i = 0; i < n; ++i) {
        diff += (ans[0][i] != ans[2][i]);
    }
    if (diff != num[1]) {
        cout << "No\n";
        return;
    }
    diff = 0;
    for (int i = 0; i < n; ++i) {
        diff += (ans[1][i] != ans[2][i]);
    }
    if (diff != num[2]) {
        cout << "No\n";
        return;
    }
    cout << "Yes\n";
    for (int i = 0; i < 3; ++i) {
        cout << ans[order[i]] << '\n';
    }
}

void solve(){
    E();
}

int main(){
    ios_base::sync_with_stdio(0);
    cin.tie(0); cout.tie(0);
    int t = 1;
    //cin >> t;
    while (t--)
        solve();
}