#include <iostream>
#include <vector>
#include <set>
#include <string>
using namespace std;

struct Instruction {
    char op;
    int val;
    bool is_async;
};

int n;
vector<Instruction> instructions;
set<int> possible_values;

void backtrack(vector<bool>& used, vector<int>& order) {
    if (order.size() == n) {
        int A = 0;
        for (int idx : order) {
            if (instructions[idx].op == '=') {
                A = instructions[idx].val;
            } else {
                A += instructions[idx].val;
            }
        }
        possible_values.insert(A);
        return;
    }
    
    for (int i = 0; i < n; i++) {
        if (used[i]) continue;
        
        bool can_place = true;
        for (int j = 0; j < i; j++) {
            if (!instructions[j].is_async && !used[j]) {
                can_place = false;
                break;
            }
        }
        
        if (can_place) {
            used[i] = true;
            order.push_back(i);
            backtrack(used, order);
            order.pop_back();
            used[i] = false;
        }
    }
}

int main() {
    cin >> n;
    instructions.resize(n);
    
    for (int i = 0; i < n; i++) {
        char op;
        int val;
        string sync_type;
        cin >> op >> val >> sync_type;
        
        instructions[i].op = op;
        instructions[i].val = val;
        instructions[i].is_async = (sync_type == "async");
    }
    
    vector<bool> used(n, false);
    vector<int> order;
    backtrack(used, order);
    
    cout << possible_values.size() << endl;
    
    return 0;
}