#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;

string multiply(const string& num1, const string& num2) {
    if (num1 == "0" || num2 == "0") {
        return "0";
    }

    int n1 = num1.size();
    int n2 = num2.size();
    vector<int> result(n1 + n2, 0); 

    for (int i = n1 - 1; i >= 0; i--) {
        int carry = 0;
        int digit1 = num1[i] - '0';
        for (int j = n2 - 1; j >= 0; j--) {
            int digit2 = num2[j] - '0';
            int sum = digit1 * digit2 + result[i + j + 1] + carry;
            carry = sum / 10;
            result[i + j + 1] = sum % 10;
        }
        result[i] += carry;
    }

    string res = "";
    int i = 0;
    while (i < result.size() - 1 && result[i] == 0) {
        i++;
    }

    while (i < result.size()) {
        res += (char)(result[i++] + '0');
    }
    
    return res;
}

void solve() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    string s, c_str;
    if (!(cin >> s >> c_str)) {
        return;
    }

    int n = s.length();

    for (int i = 1; i < n; ++i) {
        int a_len = i;
        int b_len = n - i;

        if ((a_len > 1 && s[0] == '0') || (b_len > 1 && s[i] == '0')) {
            continue;
        }

        if (a_len < c_str.length() + b_len - 1 || a_len > c_str.length() + b_len) {
             continue;
        }
        
        string b_str_temp = s.substr(i); 
        string result_multiplied = multiply(c_str, b_str_temp);

        if (a_len != result_multiplied.length()) {
            continue;
        }
        
        bool match = true;
        for (int k = 0; k < a_len; ++k) {
            if (s[k] != result_multiplied[k]) {
                match = false;
                break;
            }
        }

        if (match) {
            cout << s.substr(0, i) << " " << s.substr(i) << "\n";
            return;
        }
    }
}

int main() {
    solve();
    return 0;
}