#pragma GCC optimize("Ofast")
#include <vector>
#pragma GCC target("avx2,avx,sse,fma")

#include <bits/stdc++.h>
using namespace std;

#define ff first
#define ss second
#define all(x) x.begin(),x.end()
#define rall(x) x.rbegin(),x.rend()

using ull = unsigned long long;
using ll = long long;
using ld = long double;


map<pair<int, int>, char> cache;

char get_clr(pair<int, int> x) {
    if (!cache.count(x)) {
        cout << "? " << x.ff << ' ' << x.ss << endl;
        char ans;
        cin >> ans;

        if (ans == '0') exit(0);

        cache[x] = ans;
    }
    return cache[x];
}


void print_answer(char clr, const set<pair<int, int>> &ans) {
    cout << "! " << clr << ' ';
    for (auto i : ans) {
        cout << i.ff << ' ' << i.ss << ' ';
    }
    cout << endl;
}

random_device rd;
mt19937 rnd(rd());
normal_distribution<double> get_coord(0, 1'000'000);


void try_add_cell(pair<int, int> p, set<pair<int, int>> &points, vector<pair<int, int>> &que) {
    if (points.count(p)) return;
    points.insert(p);

    set<pair<int, int>> existed;
    for (int i = 0; i < (int)que.size(); i++) {
        if (abs(que[i].ff - p.ff) == 1 && abs(que[i].ss - p.ss) == 1) {
            existed.insert(que[i]);
        }
    }

    for (int i = -1; i <= 1; i++) {
        for (int j = -1; j <= 1; j++) {
            if (i == 0 && j == 0 || existed.count({p.ff + i, p.ss + j})) continue;
            que.push_back({p.ff + i, p.ss + j});
        }
    }
}


void solve(int n) {
    cache.clear();
    set<pair<int, int>> ans;
    vector<pair<int, int>> que;

    try_add_cell({(int)get_coord(rnd), (int)get_coord(rnd)}, ans, que);
    char clr = get_clr(*(ans.begin()));

    while (ans.size() < n) {
        if (que.size() == 0) {
            set<pair<int, int>> new_ans;
            vector<pair<int, int>> new_que;

            char new_clr;
            if (clr == 'B') new_clr = 'W';
            else new_clr = 'B';

            for (auto cur : ans) {
                for (int i = -1; i <= 1; i++) {
                    for (int j = -1; j <= 1; j++) {
                        if (i == 0 && j == 0) continue;
                        if (get_clr({cur.ff + i, cur.ss + j}) == new_clr) {
                            try_add_cell({cur.ff + i, cur.ss + j}, new_ans, new_que);
                        }
                    }
                }
            }

            ans = new_ans;
            que = new_que;

            continue;
        }

        int tmp = rnd() % que.size();
        pair<int, int> cur = que[tmp];
        que.erase(que.begin() + tmp);

        if (get_clr(cur) != clr) continue;

        try_add_cell(cur, ans, que);
    }

    print_answer(clr, ans);
}


int main() {
    //ios_base::sync_with_stdio(false);
    //cin.tie(0);

    int testsCount, n;
    cin >> testsCount >> n;

    for (int curTest = 1; curTest <= testsCount; curTest++) {
        solve(n);
    }

    return 0;
}
