#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
#include <set>
#include <map>

using namespace std;

#ifdef Local
#define debug(...) cerr << __LINE__ << " : " << #__VA_ARGS__ << " = " << __VA_ARGS__ << endl
#else
//#define endl '\n'
#define debug(...) 1337
#endif

//#define int int64_t

using ll = long long;
using ld = long double;

#define all(x) x.begin(), x.end()
#define sz(x) (int)x.size()

template <typename T, typename U>
bool smin(T& _a, U&& _b) {
    if (_a > _b) {
        _a = _b;
        return true;
    }
    return false;
}

template <typename T, typename U>
bool smax(T& _a, U&& _b) {
    if (_a < _b) {
        _a = _b;
        return true;
    }
    return false;
}

const char endc = '\n';

int n;

const int maxq = 30'000;
set<pair<int, int>> ms[maxq];
map<pair<int, int>, int> color, num;

int cnt = 0;

int tmp = 0;

set<pair<int, int>> ss;

int query(int x, int y) {
    if (color.count({x, y})) {
        return color[{x, y}];
    }
    cout << "? " << x << ' ' << y << endl;
    char c;
    cin >> c;
    if (c == 'B') {
        color[{x, y}] = 1;
    } else {
        color[{x, y}] = 2;
    }
    return color[{x, y}];
}

bool areWeKnow(int x, int y) {
    return color.count({x, y}) > 0;
}

int t;

set<pair<int, int>> used2;

int dfs2(int x, int y) {
    cout << x << ' ' << y << ' ';
    --t;
    if (t == 0) {
        return -1;
    }
    used2.insert({x, y});
    int c = color[{x, y}];
    for (int i = -1; i <= 1; ++i) {
        for (int j = -1; j <= 1; ++j) {
            if (i == 0 && j == 0) {
                continue;
            }
            if (used2.count({x + i, y + j})) {
                continue;
            }
            if (areWeKnow(x + i, y + j) && color[{x + i, y + j}] == c) {
                if (dfs2(x + i, y + j) == -1) {
                    return -1;
                }
            }
        }
    }
    return 0;
}

set<int> used3;

int merge(int i, int j) {
    if (i == j) {
        return 0;
    }
    if (sz(ms[i]) < sz(ms[j])) {
        swap(i, j);
    }
    ss.erase({sz(ms[i]), i});
    ss.erase({sz(ms[j]), j});
    for (auto k : ms[j]) {
        num[k] = i;
        ms[i].insert(k);
    }
    if (!used3.count(i)) {
        ss.insert({sz(ms[i]), i});
    }
    if (sz(ms[i]) >= n) {
        int biggest = i;
        cout << "! " << (color[*ms[biggest].begin()] == 1 ? "B" : "W") << ' ';
        t = n;
        dfs2(ms[biggest].begin()->first, ms[biggest].begin()->second);
        return -1;
    }
    return 0;
}

int merge(int x, int y, int a, int b) {
    if (num.count({x, y}) == 0) {
        num[{x, y}] = ++cnt;
        ms[cnt] = {{x, y}};
        ss.insert({1, cnt});
    }
    if (num.count({a, b}) == 0) {
        num[{a, b}] = ++cnt;
        ms[cnt] = {{a, b}};
        ss.insert({1, cnt});
    }
    return merge(num[{x, y}], num[{a, b}]);
}

int connect(int x, int y) {
    int c = color[{x, y}];
    for (int i = -1; i <= 1; ++i) {
        for (int j = -1; j <= 1; ++j) {
            if (i == 0 && j == 0) {
                continue;
            }
            if (areWeKnow(x + i, y + j) && color[{x + i, y + j}] == c) {
                if (merge(x, y, x + i, y + j) == -1) {
                    return -1;
                }
            }
        }
    }
    return 0;
}

set<pair<int, int>> used;

auto biggest_comp() {
    vector<pair<int, int>> ans;
    int j = 0;
    for (int i = 0; i <= cnt; ++i) {
        if (sz(ms[i]) > sz(ms[j])) {
            j = i;
        }
    }
    return ms[j];
}

void solve() {
    used2 = {};
    fill(ms, ms + maxq, set<pair<int, int>>{});
    color = num = {};
    int x = 111777, y = 1488;
    cnt = 0;
    ss = {};
    color[{x, y}] = query(x, y);
    num[{x, y}] = ++cnt;
    ms[cnt] = {{x, y}};
    used = {};
    while (true) {
        auto s = biggest_comp();
        int flag = 0;
        for (auto& [x, y] : s) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) {
                        continue;
                    }
                    if (areWeKnow(x + i, y + j)) {
                        continue;
                    }
                    query(x + i, y + j);
                    if (connect(x + i, y + j) == -1) {flag = 2; break;}
                    else flag = 1;
                }
                if (flag == 2) break;
            }
            if (flag) break;
        }
        if (flag == 2)
            break;
    }
}


signed main() {
//    ios::sync_with_stdio(false), cin.tie(nullptr);

    int tt = 1;
    cin >> tt >> n;
    while (tt--) {
        solve();
    }

    return 0;
}