﻿#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <unordered_map>
#include <queue>
#include <iomanip>
#include <functional>
#include <numeric>
#include <cstring>
#include <math.h>
#include <string>


using namespace std;

typedef long long ll;


void solve();

int main() {
	ios_base::sync_with_stdio(0);
	cin.tie(nullptr);

	int t = 1;
	cin >> t;

	while (t--) {
		solve();
	}
}

void solve() {
	int n;
	cin >> n;
	unordered_map<string, int> a1;
	unordered_map<string, int> a2;

	vector<pair<string, string>> input(n);
	for (int i = 0; i < n; ++i) {
		string s1, s2;
		cin >> s1 >> s2;
		input[i] = make_pair(s1, s2);
		++a1[s1];
		++a2[s2];
	}

	bool flag = true;
	string prev1 = input[0].first;
	string prev2 = input[0].second;
	--a1[prev1];
	--a2[prev2];
	for (int i = 1; i < n; ++i) {
		string s1 = input[i].first;
		string s2 = input[i].second;

		if (prev1 == s1 || prev2 == s2) {
			--a1[s1];
			--a2[s2];
		}
		else {
			if (a1[prev1] > 0 || a2[prev2] > 0) {
				flag = false;
				break;
			}
			else {
				--a1[s1];
				--a2[s2];
			}
		}
		
		prev1 = s1;
		prev2 = s2;
	}

	if (flag) cout << "Yes\n";
	else cout << "No\n";

}