#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;

struct Instruction {
    char op;
    int val;
    std::string type;
};

const int kMaxN = 2000 + 1;
const int kMaxValue = 500 + 1;
const int kMaxAnswer = kMaxN * kMaxValue;

void solve(){
    int n;
    std::cin >> n;
    std::vector<Instruction> sp(n);
    std::vector<int> eq_async;
    int last_eq = -1;
    for (int i = 0; i < n; ++i) {
        std::cin >> sp[i].op >> sp[i].val >> sp[i].type;
        if (sp[i].op == '=') {
            last_eq = i;
            if (sp[i].type == "async") {
                eq_async.push_back(i);
            }
        }
    }
    std::bitset<kMaxAnswer> sync_ans;
    std::bitset<kMaxAnswer> ans;
    if (last_eq != -1 && sp[last_eq].type == "sync") {
        std::bitset<kMaxAnswer> cur;
        int sum_after = 0;
        for (int i = last_eq + 1; i < n; ++i) {
            if (sp[i].op == '+') {
                sum_after += sp[i].val;
            }
        }
        int start = sp[last_eq].val + sum_after;
        cur[start] = 1;
        for (int i = 0; i < last_eq; ++i) {
            if (sp[i].op == '+' && sp[i].type == "async") {
                cur |= (cur << sp[i].val);
            }
        }
        sync_ans |= cur;
    }
    {
        std::bitset<kMaxAnswer> cur;
        int sum_after = 0;
        for (int i = last_eq + 1; i < n; ++i) {
            if (sp[i].op == '+') {
                sum_after += sp[i].val;
            }
        }
        cur[sum_after] = 1;
        for (int i = 0; i < last_eq; ++i) {
            if (sp[i].op == '+' && sp[i].type == "async") {
                cur |= (cur << sp[i].val);
            }
        }
        std::bitset<kMaxAnswer> tmp;
        for (auto ind : eq_async) {
            tmp |= (cur << sp[ind].val);
        }
        ans |= tmp;
        for (int i = last_eq + 1; i < n; ++i) {
            if (sp[i].op == '+') {
                tmp = (tmp >> sp[i].val);
                if (sp[i].type == "async") {
                    tmp |= (tmp << sp[i].val);
                }
            }
            ans |= tmp;
        }
    }
    std::cout << (sync_ans | ans).count() << "\n";
}

signed main(){
    freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int t = 1;
    //cin >> t;
    while(t--){
        solve();
    }
    return 0;
}
